/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl.condition;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbranks.FTBRanks;
import dev.ftb.mods.ftbranks.api.RankCondition;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3468;

public class PlaytimeCondition
implements RankCondition {
    public static final int TICKS = 1;
    public static final int SECONDS = 20;
    public static final int MINUTES = 1200;
    public static final int HOURS = 72000;
    public static final int DAYS = 1728000;
    public static final int WEEKS = 12096000;
    private final int time;
    private final int timeUnit;
    private final class_3445<class_2960> stat;

    public PlaytimeCondition(SNBTCompoundTag tag) {
        this.time = tag.method_10550("time");
        if (!tag.method_10545("time_unit")) {
            FTBRanks.LOGGER.warn("missing 'time_unit' field in playtime condition - assuming 'ticks'");
        }
        switch (tag.method_10558("time_unit")) {
            case "seconds": {
                this.timeUnit = 20;
                break;
            }
            case "minutes": {
                this.timeUnit = 1200;
                break;
            }
            case "hours": {
                this.timeUnit = 72000;
                break;
            }
            case "days": {
                this.timeUnit = 1728000;
                break;
            }
            case "weeks": {
                this.timeUnit = 12096000;
                break;
            }
            default: {
                this.timeUnit = 1;
            }
        }
        this.stat = class_3468.field_15419.method_14956((Object)class_3468.field_15417);
    }

    @Override
    public String getType() {
        return "playtime";
    }

    @Override
    public boolean isRankActive(class_3222 player) {
        return player.method_14248().method_15025(this.stat) >= this.time * this.timeUnit;
    }

    @Override
    public void save(SNBTCompoundTag tag) {
        tag.method_10569("time", this.time);
        switch (this.timeUnit) {
            case 20: {
                tag.method_10582("time_unit", "seconds");
                break;
            }
            case 1200: {
                tag.method_10582("time_unit", "minutes");
                break;
            }
            case 72000: {
                tag.method_10582("time_unit", "hours");
                break;
            }
            case 1728000: {
                tag.method_10582("time_unit", "days");
                break;
            }
            case 12096000: {
                tag.method_10582("time_unit", "weeks");
                break;
            }
            default: {
                tag.method_10582("time_unit", "ticks");
            }
        }
    }
}

