/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.yetanotherchancebooster.boost;

public abstract class Boost {
    private float amplifier;
    private long ticksRemain;

    public Boost(float amplifier, long duration) {
        this.amplifier = amplifier;
        this.ticksRemain = duration;
    }

    public void tick() {
        if (this.ticksRemain > 0L) {
            --this.ticksRemain;
        }
    }

    public boolean isEnded() {
        return this.ticksRemain <= 0L;
    }

    public void setTicksRemain(long ticksRemain) {
        this.ticksRemain = ticksRemain;
    }

    public void addDuration(long value) {
        this.ticksRemain += value;
    }

    public long getTicksRemain() {
        return this.ticksRemain;
    }

    public float getAmplifier() {
        return this.amplifier;
    }

    public void setAmplifier(float amplifier) {
        this.amplifier = amplifier;
    }

    public void update(float amplifier, long duration) {
        this.setAmplifier(amplifier);
        this.addDuration(duration);
    }

    public void update(Boost boost) {
        this.update(boost.amplifier, boost.ticksRemain);
    }

    public void end() {
        this.setAmplifier(0.0f);
        this.setTicksRemain(0L);
    }

    public abstract String info();
}

