/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.yetanotherchancebooster.boost;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.metacontent.yetanotherchancebooster.YetAnotherChanceBooster;
import com.metacontent.yetanotherchancebooster.boost.Boost;
import com.metacontent.yetanotherchancebooster.boost.LabelWeightBoost;
import com.metacontent.yetanotherchancebooster.boost.ShinyBoost;
import com.metacontent.yetanotherchancebooster.boost.SpeciesWeightBoost;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class BoostManager {
    public static final int SAVE_PERIOD = YetAnotherChanceBooster.CONFIG.savePeriod();
    private final ShinyBoost shinyBoost = new ShinyBoost();
    private final Map<String, SpeciesWeightBoost> speciesWeightBoosts = new HashMap<String, SpeciesWeightBoost>();
    @JsonAdapter(value=LabelMapAdapter.class)
    private final Map<Set<String>, LabelWeightBoost> labelWeightBoosts = new HashMap<Set<String>, LabelWeightBoost>();
    private final List<Boost> endedBoosts = new ArrayList<Boost>();
    private boolean shouldSave = false;
    private int saveTimer = SAVE_PERIOD;

    public void tick() {
        this.tickAndCheckBoost(this.shinyBoost);
        this.speciesWeightBoosts.entrySet().removeIf(boostEntry -> {
            SpeciesWeightBoost boost = (SpeciesWeightBoost)boostEntry.getValue();
            return this.tickAndCheckBoost(boost);
        });
        this.labelWeightBoosts.entrySet().removeIf(boostEntry -> {
            LabelWeightBoost boost = (LabelWeightBoost)boostEntry.getValue();
            return this.tickAndCheckBoost(boost);
        });
        if (!this.shouldSave) {
            --this.saveTimer;
        }
        if (this.saveTimer <= 0) {
            this.shouldSave = true;
            this.saveTimer = SAVE_PERIOD;
        }
    }

    private boolean tickAndCheckBoost(Boost boost) {
        boost.tick();
        if (boost.isEnded()) {
            this.endedBoosts.add(boost);
            this.shouldSave = true;
        }
        return boost.isEnded();
    }

    private void tickAndCheckBoost(ShinyBoost boost) {
        boost.tick();
        if (boost.isActive() && boost.isEnded()) {
            boost.setActive(false);
            this.endedBoosts.add(boost);
        }
    }

    public boolean isSaveNeeded() {
        return this.shouldSave;
    }

    public void setShouldSave(boolean shouldSave) {
        this.shouldSave = shouldSave;
    }

    public void addBoost(SpeciesWeightBoost boost) {
        SpeciesWeightBoost existingBoost = this.getBoost(boost.getSpecies());
        if (existingBoost == null) {
            this.speciesWeightBoosts.put(boost.getSpecies(), boost);
        } else {
            existingBoost.update(boost);
        }
        this.shouldSave = true;
    }

    public void addBoost(LabelWeightBoost boost) {
        LabelWeightBoost existingBoost = this.getBoost(boost.getLabels());
        if (existingBoost == null) {
            this.labelWeightBoosts.put(boost.getLabels(), boost);
        } else {
            existingBoost.update(boost);
        }
        this.shouldSave = true;
    }

    public void addShinyBoost(float amplifier, long duration) {
        this.shinyBoost.update(amplifier, duration);
        this.shinyBoost.setActive(true);
        this.shouldSave = true;
    }

    public float getShinyAmplifier() {
        float amplifier = 0.0f;
        if (!this.shinyBoost.isEnded()) {
            amplifier = this.shinyBoost.getAmplifier();
        }
        return amplifier;
    }

    public float getWeightAmplifier(String species) {
        float amplifier = 1.0f;
        SpeciesWeightBoost weightBoost = this.getBoost(species);
        if (weightBoost != null) {
            amplifier = weightBoost.getAmplifier();
        }
        return amplifier;
    }

    public float getWeightAmplifier(Set<String> labels) {
        Set<LabelWeightBoost> weightBoosts = this.getLabelWeightBoosts(labels);
        if (weightBoosts.isEmpty()) {
            return 1.0f;
        }
        float amplifier = 0.0f;
        for (LabelWeightBoost boost : weightBoosts) {
            amplifier += boost.getAmplifier();
        }
        return amplifier;
    }

    public ShinyBoost getShinyBoost() {
        return this.shinyBoost;
    }

    @Nullable
    public SpeciesWeightBoost getBoost(String species) {
        return this.speciesWeightBoosts.get(species);
    }

    @Nullable
    public LabelWeightBoost getBoost(Set<String> labels) {
        return this.labelWeightBoosts.get(labels);
    }

    public Set<LabelWeightBoost> getLabelWeightBoosts(Set<String> labels) {
        return this.labelWeightBoosts.entrySet().stream().filter(entry -> labels.containsAll((Collection)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public String getShinyBoostString() {
        return this.shinyBoost.toString();
    }

    public List<String> listSpeciesWeightBoosts() {
        return this.speciesWeightBoosts.values().stream().map(SpeciesWeightBoost::toString).toList();
    }

    public List<String> listLabelWeightBoosts() {
        return this.labelWeightBoosts.values().stream().map(LabelWeightBoost::toString).toList();
    }

    public void endShinyBoost() {
        this.shinyBoost.end();
    }

    public void endWeightBoost(String species) {
        SpeciesWeightBoost boost = this.getBoost(species);
        if (boost != null) {
            boost.end();
        }
    }

    public void endWeightBoost(Set<String> labels) {
        LabelWeightBoost boost = this.getBoost(labels);
        if (boost != null) {
            boost.end();
        }
    }

    public void endAll() {
        this.endShinyBoost();
        this.speciesWeightBoosts.keySet().forEach(this::endWeightBoost);
        this.labelWeightBoosts.keySet().forEach(this::endWeightBoost);
    }

    public List<Boost> getEndedBoosts() {
        return this.endedBoosts;
    }

    public static class LabelMapAdapter
    extends TypeAdapter<Map<Set<String>, LabelWeightBoost>> {
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

        public void write(JsonWriter out, Map<Set<String>, LabelWeightBoost> value) throws IOException {
            GSON.toJson(value, value.getClass(), out);
        }

        public Map<Set<String>, LabelWeightBoost> read(JsonReader in) throws IOException {
            Type type = new TypeToken<Map<String, LabelWeightBoost>>(){}.getType();
            Map rawMap = (Map)GSON.fromJson(in, type);
            return rawMap.entrySet().stream().map(entry -> {
                String string = (String)entry.getKey();
                Set labels = Set.of(string.substring(1, string.length() - 1).split(",")).stream().map(String::strip).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                return Map.entry(labels, (LabelWeightBoost)entry.getValue());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

