/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.yetanotherchancebooster.command;

import com.metacontent.yetanotherchancebooster.YetAnotherChanceBooster;
import com.metacontent.yetanotherchancebooster.boost.BoostManager;
import com.metacontent.yetanotherchancebooster.command.Command;
import com.metacontent.yetanotherchancebooster.command.Commands;
import com.metacontent.yetanotherchancebooster.config.LanguageConfig;
import com.metacontent.yetanotherchancebooster.store.BoostManagerData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class ListBoostsCommand
implements Command {
    public static final List<String> LIST_TYPES = List.of("all", "shiny", "species", "labels");
    public static final String LIST = "list";
    public static final String PLAYER = "player";
    public static final String LIST_TYPE = "boosts";

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.BASE_COMMAND.then(class_2170.method_9247((String)LIST).then(class_2170.method_9244((String)PLAYER, (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)LIST_TYPE, (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (String type : LIST_TYPES) {
                if (!class_2172.method_27136((String)builder.getRemaining(), (String)type)) continue;
                builder.suggest(type);
            }
            return builder.buildFuture();
        }).executes(this::run)))));
    }

    @Override
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 source = ((class_2168)context.getSource()).method_9207();
        class_3222 player = class_2186.method_9315(context, (String)PLAYER);
        String type = StringArgumentType.getString(context, (String)LIST_TYPE);
        ArrayList<String> list = new ArrayList<String>();
        BoostManager manager = BoostManagerData.getOrCreate(player).getManager();
        LanguageConfig language = YetAnotherChanceBooster.LANGUAGE;
        switch (type) {
            default: {
                break;
            }
            case "all": {
                list.add(language.shiny());
                list.add(manager.getShinyBoostString());
                list.add(language.species());
                list.addAll(manager.listSpeciesWeightBoosts());
                list.add(language.labels());
                list.addAll(manager.listLabelWeightBoosts());
                break;
            }
            case "shiny": {
                list.add(language.shiny());
                list.add(manager.getShinyBoostString());
                break;
            }
            case "species": {
                list.add(language.species());
                list.addAll(manager.listSpeciesWeightBoosts());
                break;
            }
            case "labels": {
                list.add(language.labels());
                list.addAll(manager.listLabelWeightBoosts());
            }
        }
        list.forEach(string -> source.method_43496((class_2561)class_2561.method_43470((String)string)));
        return 1;
    }
}

