/*
 * Decompiled with CFR 0.152.
 */
package net.werdei.configloader;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import net.werdei.configloader.ConfigException;

public abstract class ConfigLoader {
    private static final GsonBuilder gsonBuilder = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).setPrettyPrinting();

    public static void load(Class<?> configClass, String fileName) {
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), fileName);
        try {
            FileReader reader = new FileReader(file);
            gsonBuilder.create().fromJson((Reader)reader, configClass);
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save(Class<?> configClass, String fileName) throws ConfigException {
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), fileName);
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(gsonBuilder.create().toJson(configClass.getConstructor(new Class[0]).newInstance(new Object[0])));
            writer.close();
        }
        catch (Exception e) {
            throw new ConfigException("Error creating a temporary instance of class " + configClass.getName(), e);
        }
    }
}

