/*
 * Decompiled with CFR 0.152.
 */
package net.werdei.serverhats;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2291;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.werdei.serverhats.Config;
import net.werdei.serverhats.command.HatsCommand;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHats
implements ModInitializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LOG_PREFIX = "[ServerHats]: ";
    private static HashSet<class_1792> allowedItems = null;
    private static boolean itemListsInitialized = false;
    private static class_7225<class_1792> itemRegistryWrapper;

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            HatsCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
            itemRegistryWrapper = registryAccess.method_41699(class_7924.field_41197);
        });
    }

    public static void reloadConfig() {
        ServerHats.reloadConfig(null, null);
    }

    public static void reloadConfig(OnOutput info, OnOutput warning) {
        if (info == null) {
            info = ServerHats::log;
        }
        if (warning == null) {
            warning = ServerHats::warn;
        }
        Config.load();
        Config.save();
        ServerHats.recalculateItemLists(info, warning);
        String itemCount = Config.allowAllItems ? "all" : Integer.toString(allowedItems.size());
        info.sendMessage("Successfully added ability to equip " + itemCount + " items");
    }

    public static void recalculateItemLists(OnOutput info, OnOutput warning) {
        itemListsInitialized = false;
        allowedItems = new HashSet();
        List.of(Config.allowedItems).forEach(string -> {
            try {
                Either either = class_2291.method_41974(itemRegistryWrapper, (StringReader)new StringReader(string));
                either.ifLeft(itemResult -> ServerHats.addAllowedItem((class_1792)itemResult.comp_628().comp_349(), warning));
                either.ifRight(tagResult -> tagResult.comp_630().forEach(item -> ServerHats.addAllowedItem((class_1792)item.comp_349(), warning)));
            }
            catch (CommandSyntaxException e) {
                warning.sendMessage("Skipping \"" + string + "\": " + e.getMessage());
            }
        });
        itemListsInitialized = true;
    }

    private static void addAllowedItem(class_1792 item, OnOutput warning) {
        if (ServerHats.isItemRestricted(item)) {
            warning.sendMessage("Skipping \"" + item.method_7848() + "\": The item can already be equipped in a helmet slot");
        } else {
            allowedItems.add(item);
        }
    }

    public static boolean isItemAllowed(class_1799 stack) {
        if (!itemListsInitialized) {
            return false;
        }
        if (Config.allowAllItems) {
            return !ServerHats.isItemRestricted(stack);
        }
        return allowedItems.contains(stack.method_7909());
    }

    private static boolean isItemRestricted(class_1792 item) {
        return ServerHats.isItemRestricted(new class_1799((class_1935)item));
    }

    private static boolean isItemRestricted(class_1799 stack) {
        return class_1309.method_32326((class_1799)stack) == class_1304.field_6169;
    }

    public static void log(Object message) {
        LOGGER.info(LOG_PREFIX + message);
    }

    public static void warn(Object message) {
        LOGGER.warn(LOG_PREFIX + message);
    }

    public static interface OnOutput {
        public void sendMessage(String var1);
    }
}

