/*
 * Decompiled with CFR 0.152.
 */
package net.werdei.serverhats.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.reflect.Field;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.werdei.serverhats.Config;
import net.werdei.serverhats.ServerHats;
import net.werdei.serverhats.command.ItemPredicateIdentifier;

public class HatsCommand {
    private static class_7225<class_1792> itemRegistryWrapper;

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess) {
        itemRegistryWrapper = commandRegistryAccess.method_41699(class_7924.field_41197);
        LiteralArgumentBuilder rootArgument = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hats").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"reload").executes(context -> HatsCommand.reload((class_2168)context.getSource())));
        for (Field configField : Config.class.getDeclaredFields()) {
            if (configField.getType() != Boolean.TYPE) continue;
            String configName = configField.getName();
            LiteralArgumentBuilder configArgumentBuilder = class_2170.method_9247((String)configName);
            configArgumentBuilder.executes(context -> HatsCommand.getSimpleConfigValue((class_2168)context.getSource(), configName));
            configArgumentBuilder.then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> HatsCommand.setBooleanConfigValue((class_2168)context.getSource(), configName, BoolArgumentType.getBool((CommandContext)context, (String)"value"))));
            rootArgument.then((ArgumentBuilder)configArgumentBuilder);
        }
        LiteralArgumentBuilder allowedItemsArgument = class_2170.method_9247((String)"allowedItems");
        String argumentName = "item or item tag";
        allowedItemsArgument.then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)argumentName, (ArgumentType)StringArgumentType.greedyString()).executes(context -> HatsCommand.allowItems((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)argumentName)))));
        allowedItemsArgument.then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)argumentName, (ArgumentType)StringArgumentType.greedyString()).executes(context -> HatsCommand.disallowItems((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)argumentName)))));
        allowedItemsArgument.executes(context -> HatsCommand.getArrayConfigValue((class_2168)context.getSource(), "allowedItems"));
        rootArgument.then((ArgumentBuilder)allowedItemsArgument);
        LiteralCommandNode command = dispatcher.register(rootArgument);
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"serverhats").redirect((CommandNode)command));
    }

    private static int reload(class_2168 source) {
        try {
            ServerHats.reloadConfig(s -> source.method_9226(() -> class_2561.method_43470((String)s), true), s -> source.method_9213((class_2561)class_2561.method_43470((String)s)));
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Could not load a configuration file: " + e.getMessage())));
            return 1;
        }
        return 0;
    }

    private static int setBooleanConfigValue(class_2168 source, String name, boolean value) {
        try {
            Field field = Config.class.getField(name);
            if (field.getBoolean(null) == value) {
                source.method_9213((class_2561)class_2561.method_43470((String)(name + " is already set to " + value)));
                return 0;
            }
            field.setBoolean(null, value);
            source.method_9226(() -> class_2561.method_43470((String)(name + " is now set to " + value)), true);
            Config.save();
            return value ? 2 : 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int getSimpleConfigValue(class_2168 source, String name) {
        try {
            Object field = Config.class.getField(name).get(null);
            source.method_9226(() -> class_2561.method_43470((String)(name + " is currently set to " + field)), true);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int getArrayConfigValue(class_2168 source, String name) {
        try {
            Field field = Config.class.getField(name);
            Object[] array = (Object[])field.get(null);
            source.method_9226(() -> class_2561.method_43470((String)(name + " currently contains: ")), true);
            StringBuilder contents = new StringBuilder();
            boolean first = true;
            for (Object obj : array) {
                contents.append(first ? "" : ", ");
                first = false;
                contents.append(obj.toString());
            }
            source.method_9226(() -> class_2561.method_43470((String)contents.toString()), true);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int allowItems(class_2168 source, String string) throws CommandSyntaxException {
        if (Config.allowAllItems) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Cannot modify allowed item list while \"allowAllItems\" is set to \"true\""));
            return 0;
        }
        ItemPredicateIdentifier itemPredicate = ItemPredicateIdentifier.fromString(string, itemRegistryWrapper);
        if (Config.addAllowedItemId(itemPredicate.id, itemPredicate.isTag)) {
            ServerHats.recalculateItemLists(s -> source.method_9226(() -> class_2561.method_43470((String)s), true), s -> source.method_9213((class_2561)class_2561.method_43470((String)s)));
            source.method_9226(() -> class_2561.method_43470((String)"Successfully updated allowedItems list"), true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)((itemPredicate.isTag ? "Item tag " : "Item ") + itemPredicate.id + " is already in the allowedItems list")));
        return 0;
    }

    private static int disallowItems(class_2168 source, String string) throws CommandSyntaxException {
        if (Config.allowAllItems) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Cannot modify allowed item list while \"allowAllItems\" is set to \"true\""));
            return 0;
        }
        ItemPredicateIdentifier itemPredicate = ItemPredicateIdentifier.fromString(string, itemRegistryWrapper);
        if (Config.removeAllowedItemId(itemPredicate.id, itemPredicate.isTag)) {
            ServerHats.recalculateItemLists(s -> source.method_9226(() -> class_2561.method_43470((String)s), true), s -> source.method_9213((class_2561)class_2561.method_43470((String)s)));
            source.method_9226(() -> class_2561.method_43470((String)"Successfully updated allowedItems list"), true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)((itemPredicate.isTag ? "Item tag " : "Item ") + itemPredicate.id + " is already not in the allowedItems list")));
        return 0;
    }
}

