/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.configuration.key;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.impactdev.impactor.api.configuration.adapter.ConfigurationAdapter;
import net.impactdev.impactor.api.configuration.key.SimpleConfigKey;

public interface ConfigKeyFactory<T> {
    public static final ConfigKeyFactory<Boolean> BOOLEAN = ConfigurationAdapter::getBoolean;
    public static final ConfigKeyFactory<String> STRING = ConfigurationAdapter::getString;
    public static final ConfigKeyFactory<Integer> INTEGER = ConfigurationAdapter::getInteger;
    public static final ConfigKeyFactory<Long> LONG = ConfigurationAdapter::getLong;
    public static final ConfigKeyFactory<Double> DOUBLE = ConfigurationAdapter::getDouble;
    public static final ConfigKeyFactory<List<String>> STRING_LIST = ConfigurationAdapter::getStringList;
    public static final ConfigKeyFactory<String> LOWERCASE_STRING = (adapter, path, def) -> adapter.getString(path, (String)def).toLowerCase(Locale.ROOT);
    public static final ConfigKeyFactory<Map<String, String>> STRING_MAP = (config, path, def) -> ImmutableMap.copyOf(config.getStringMap(path, (Map<String, String>)ImmutableMap.of()));

    public static <T> SimpleConfigKey<T> key(Function<ConfigurationAdapter, T> function) {
        return new SimpleConfigKey<T>(function);
    }

    public static <T> SimpleConfigKey<T> notReloadable(SimpleConfigKey<T> key) {
        key.setReloadable(false);
        return key;
    }

    public static SimpleConfigKey<Boolean> booleanKey(String path, boolean def) {
        return ConfigKeyFactory.key(new Bound<Boolean>(BOOLEAN, path, def));
    }

    public static SimpleConfigKey<String> stringKey(String path, String def) {
        return ConfigKeyFactory.key(new Bound<String>(STRING, path, def));
    }

    public static SimpleConfigKey<Integer> intKey(String path, int def) {
        return ConfigKeyFactory.key(new Bound<Integer>(INTEGER, path, def));
    }

    public static SimpleConfigKey<Long> longKey(String path, long def) {
        return ConfigKeyFactory.key(new Bound<Long>(LONG, path, def));
    }

    public static SimpleConfigKey<Double> doubleKey(String path, double def) {
        return ConfigKeyFactory.key(new Bound<Double>(DOUBLE, path, def));
    }

    public static SimpleConfigKey<List<String>> listKey(String path, List<String> def) {
        return ConfigKeyFactory.key(new Bound<List<String>>(STRING_LIST, path, def));
    }

    public static SimpleConfigKey<String> lowercaseStringKey(String path, String def) {
        return ConfigKeyFactory.key(new Bound<String>(LOWERCASE_STRING, path, def));
    }

    public static SimpleConfigKey<Map<String, String>> mapKey(String path) {
        return ConfigKeyFactory.key(new Bound<Object>(STRING_MAP, path, null));
    }

    public T getValue(ConfigurationAdapter var1, String var2, T var3);

    public static class Bound<T>
    implements Function<ConfigurationAdapter, T> {
        private final ConfigKeyFactory<T> factory;
        private final String path;
        private final T def;

        Bound(ConfigKeyFactory<T> factory2, String path, T def) {
            this.factory = factory2;
            this.path = path;
            this.def = def;
        }

        @Override
        public T apply(ConfigurationAdapter adapter) {
            return this.factory.getValue(adapter, this.path, this.def);
        }
    }
}

