/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.economy;

import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.currency.CurrencyProvider;
import net.impactdev.impactor.api.services.Service;

public interface EconomyService
extends Service {
    public static EconomyService instance() {
        return Impactor.instance().services().provide(EconomyService.class);
    }

    public CurrencyProvider currencies();

    default public CompletableFuture<Boolean> hasAccount(UUID uuid) {
        return this.hasAccount(this.currencies().primary(), uuid);
    }

    public CompletableFuture<Boolean> hasAccount(Currency var1, UUID var2);

    default public CompletableFuture<Account> account(UUID uuid) {
        return this.account(this.currencies().primary(), uuid);
    }

    default public CompletableFuture<Account> account(UUID uuid, Account.AccountModifier modifier) {
        return this.account(this.currencies().primary(), uuid, modifier);
    }

    public CompletableFuture<Account> account(Currency var1, UUID var2);

    public CompletableFuture<Account> account(Currency var1, UUID var2, Account.AccountModifier var3);

    public CompletableFuture<Multimap<Currency, Account>> accounts();

    default public CompletableFuture<Collection<Account>> accounts(Currency currency) {
        return this.accounts().thenApply(map -> map.get((Object)currency));
    }

    default public CompletableFuture<Void> deleteAccount(UUID uuid) {
        return this.deleteAccount(this.currencies().primary(), uuid);
    }

    public CompletableFuture<Void> deleteAccount(Currency var1, UUID var2);

    @CanIgnoreReturnValue
    public CompletableFuture<Void> save(Account var1);
}

