/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.economy.accounts;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.EconomyTransferTransaction;
import net.impactdev.impactor.api.utility.builders.Builder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Account {
    @NotNull
    public Currency currency();

    @NotNull
    public UUID owner();

    public boolean virtual();

    @NotNull
    public BigDecimal balance();

    @Deprecated(forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="6.0.0")
    default public CompletableFuture<BigDecimal> balanceAsync() {
        return CompletableFuture.completedFuture(this.balance());
    }

    @NotNull
    @CanIgnoreReturnValue
    public EconomyTransaction set(BigDecimal var1);

    @Deprecated(forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="6.0.0")
    default public @NotNull CompletableFuture<@NotNull EconomyTransaction> setAsync(BigDecimal amount) {
        return CompletableFuture.completedFuture(this.set(amount));
    }

    @NotNull
    @CanIgnoreReturnValue
    public EconomyTransaction withdraw(BigDecimal var1);

    @Deprecated(forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="6.0.0")
    default public @NotNull CompletableFuture<@NotNull EconomyTransaction> withdrawAsync(BigDecimal amount) {
        return CompletableFuture.completedFuture(this.withdraw(amount));
    }

    @NotNull
    @CanIgnoreReturnValue
    public EconomyTransaction deposit(BigDecimal var1);

    @Deprecated(forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="6.0.0")
    default public @NotNull CompletableFuture<@NotNull EconomyTransaction> depositAsync(BigDecimal amount) {
        return CompletableFuture.completedFuture(this.deposit(amount));
    }

    @NotNull
    @CanIgnoreReturnValue
    public EconomyTransferTransaction transfer(Account var1, BigDecimal var2);

    @Deprecated(forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="6.0.0")
    default public @NotNull CompletableFuture<@NotNull EconomyTransferTransaction> transferAsync(Account to, BigDecimal amount) {
        return CompletableFuture.completedFuture(this.transfer(to, amount));
    }

    @NotNull
    @CanIgnoreReturnValue
    public EconomyTransaction reset();

    @Deprecated(forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="6.0.0")
    default public @NotNull CompletableFuture<@NotNull EconomyTransaction> resetAsync() {
        return CompletableFuture.completedFuture(this.reset());
    }

    public static AccountBuilder builder() {
        return Impactor.instance().builders().provide(AccountBuilder.class);
    }

    public static interface AccountBuilder
    extends Builder<Account> {
        @NotNull
        @Contract(value="_ -> this")
        @CanIgnoreReturnValue
        public AccountBuilder currency(@NotNull Currency var1);

        @NotNull
        @Contract(value="_ -> this")
        @CanIgnoreReturnValue
        public AccountBuilder owner(@NotNull UUID var1);

        @NotNull
        @Contract(value="_ -> this")
        @CanIgnoreReturnValue
        public AccountBuilder balance(@NotNull BigDecimal var1);

        @NotNull
        @Contract(value="-> this")
        @CanIgnoreReturnValue
        public AccountBuilder virtual();
    }

    @FunctionalInterface
    public static interface AccountModifier {
        public AccountBuilder modify(AccountBuilder var1);
    }
}

