/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.economy.currency;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.util.Locale;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.TriState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Currency {
    public Key key();

    public Component singular();

    public Component plural();

    public Component symbol();

    public CurrencyFormatting formatting();

    public BigDecimal defaultAccountBalance();

    public int decimals();

    public boolean primary();

    public TriState transferable();

    default public Component format(@NotNull BigDecimal amount) {
        return this.format(amount, true);
    }

    default public Component format(@NotNull BigDecimal amount, @NotNull Locale locale) {
        return this.format(amount, true, locale);
    }

    default public Component format(@NotNull BigDecimal amount, boolean condensed) {
        return this.format(amount, condensed, Locale.ROOT);
    }

    public Component format(@NotNull BigDecimal var1, boolean var2, @NotNull Locale var3);

    public static CurrencyBuilder builder() {
        return Impactor.instance().builders().provide(CurrencyBuilder.class);
    }

    public static interface CurrencyBuilder
    extends Builder<Currency> {
        @CanIgnoreReturnValue
        @Contract(value="_ -> this")
        public CurrencyBuilder key(@NotNull Key var1);

        @CanIgnoreReturnValue
        @Contract(value="_ -> this")
        public CurrencyBuilder name(@NotNull Component var1);

        @CanIgnoreReturnValue
        @Contract(value="_ -> this")
        public CurrencyBuilder plural(@NotNull Component var1);

        @CanIgnoreReturnValue
        @Contract(value="_ -> this")
        public CurrencyBuilder symbol(@NotNull Component var1);

        @CanIgnoreReturnValue
        @Contract(value="_ -> this")
        public CurrencyBuilder formatting(@NotNull CurrencyFormatting var1);

        @CanIgnoreReturnValue
        @Contract(value="_ -> this")
        public CurrencyBuilder starting(@NotNull BigDecimal var1);

        @CanIgnoreReturnValue
        @Contract(value="_ -> this")
        public CurrencyBuilder decimals(int var1);

        @CanIgnoreReturnValue
        @Contract(value="-> this")
        public CurrencyBuilder primary();

        @CanIgnoreReturnValue
        @Contract(value="_ -> this")
        public CurrencyBuilder transferable(boolean var1);
    }

    public record CurrencyFormatting(String condensed, String expanded) {
    }
}

