/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.economy.transactions;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.function.Supplier;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.composer.TransactionComposer;
import net.impactdev.impactor.api.economy.transactions.details.EconomyResultType;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EconomyTransaction {
    public static TransactionComposer compose() {
        return Impactor.instance().builders().provide(TransactionComposer.class);
    }

    public Currency currency();

    public Account account();

    public BigDecimal amount();

    public EconomyTransactionType type();

    public EconomyResultType result();

    default public boolean successful() {
        return this.result() == EconomyResultType.SUCCESS;
    }

    @Nullable
    public Supplier<Component> message();

    @NotNull
    @ApiStatus.AvailableSince(value="5.2.0")
    public Instant timestamp();

    default public void inform(Audience audience) {
        Supplier<Component> message = this.message();
        if (message != null) {
            audience.sendMessage(message.get());
        }
    }
}

