/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.economy.transactions;

import java.math.BigDecimal;
import java.util.function.Supplier;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.composer.TransferComposer;
import net.impactdev.impactor.api.economy.transactions.details.EconomyResultType;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public interface EconomyTransferTransaction {
    public static TransferComposer compose() {
        return Impactor.instance().builders().provide(TransferComposer.class);
    }

    public Currency currency();

    public Account from();

    public Account to();

    public BigDecimal amount();

    public EconomyResultType result();

    default public boolean successful() {
        return this.result() == EconomyResultType.SUCCESS;
    }

    @Nullable
    public Supplier<Component> message();

    default public void inform(Audience audience) {
        Supplier<Component> message = this.message();
        if (message != null) {
            audience.sendMessage(message.get());
        }
    }
}

