/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.economy.transactions.composer;

import com.google.common.base.Suppliers;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.details.EconomyResultType;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.impactdev.impactor.api.utility.builders.Required;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface TransactionComposer
extends Builder<EconomyTransaction> {
    @Required
    @Contract(value="_ -> this")
    @CanIgnoreReturnValue
    public TransactionComposer account(@NotNull Account var1);

    @Contract(value="_ -> this")
    @CanIgnoreReturnValue
    public TransactionComposer amount(@NotNull BigDecimal var1);

    @Required
    @Contract(value="_ -> this")
    @CanIgnoreReturnValue
    public TransactionComposer type(@NotNull EconomyTransactionType var1);

    @Contract(value="_,_ -> this")
    @CanIgnoreReturnValue
    default public TransactionComposer message(@NotNull EconomyResultType type, @NotNull Component message) {
        return this.message(type, (Supplier<Component>)Suppliers.memoize(() -> message));
    }

    @Contract(value="_,_ -> this")
    @CanIgnoreReturnValue
    public TransactionComposer message(@NotNull EconomyResultType var1, @NotNull @NotNull Supplier<@NotNull Component> var2);

    @Override
    public EconomyTransaction build();

    @Deprecated(forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="6.0.0")
    default public @NotNull CompletableFuture<@NotNull EconomyTransaction> send() {
        return CompletableFuture.completedFuture(this.build());
    }
}

