/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.events;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.impactdev.impactor.api.events.ImpactorEvent;
import net.impactdev.impactor.api.logging.Log4jLogger;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.kyori.event.EventBus;
import net.kyori.event.EventSubscriber;
import net.kyori.event.EventSubscription;
import net.kyori.event.PostResult;
import org.apache.logging.log4j.LogManager;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ImpactorEventBus
implements EventBus<ImpactorEvent> {
    private static final ImpactorEventBus INSTANCE = new ImpactorEventBus();
    private final EventBus<ImpactorEvent> delegate = EventBus.create(ImpactorEvent.class);
    private final Log4jLogger logger = new Log4jLogger(LogManager.getLogger((String)"Impactor (Events)"));

    public static ImpactorEventBus bus() {
        return INSTANCE;
    }

    private ImpactorEventBus() {
    }

    public @NonNull Class<ImpactorEvent> type() {
        return ImpactorEvent.class;
    }

    public @NonNull PostResult post(@NonNull ImpactorEvent event) {
        Supplier<PrettyPrinter> raiser = () -> {
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.title("Event Invocation Results");
            printer.add("Event: " + event.getClass().getSimpleName());
            return printer;
        };
        PostResult result = this.delegate.post((Object)event);
        if (!result.wasSuccessful()) {
            PrettyPrinter printer = raiser.get();
            printer.add("Exceptions Encountered: " + result.exceptions().size());
            printer.newline().add("Encountered exception traces will now be printed below...");
            printer.hr('-');
            AtomicInteger id = new AtomicInteger(1);
            result.exceptions().forEach((subscriber, throwable) -> {
                printer.add("%d: %s", id.getAndIncrement(), subscriber);
                printer.add((Throwable)throwable, 2);
            });
            printer.log(this.logger, PrettyPrinter.Level.ERROR);
        }
        return result;
    }

    public boolean subscribed(@NonNull Class<? extends ImpactorEvent> type) {
        return this.delegate.subscribed(type);
    }

    public <T extends ImpactorEvent> @NonNull EventSubscription subscribe(@NonNull Class<T> event, @NonNull EventSubscriber<? super T> subscriber) {
        return this.delegate.subscribe(event, subscriber);
    }

    public void unsubscribeIf(@NonNull Predicate<EventSubscriber<? super ImpactorEvent>> predicate) {
        this.delegate.unsubscribeIf(predicate);
    }
}

