/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.items;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.impactdev.impactor.api.items.ImpactorItemStack;
import net.impactdev.impactor.api.items.builders.AbstractStackBuilder;
import net.impactdev.impactor.api.items.properties.MetaFlag;
import net.impactdev.impactor.api.items.properties.enchantments.Enchantment;
import net.impactdev.impactor.api.items.types.ItemType;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.text.Component;

public abstract class AbstractedItemStack
implements ImpactorItemStack {
    protected final ItemType type;
    protected final Component title;
    protected final List<Component> lore;
    protected final int quantity;
    protected final Set<Enchantment> enchantments;
    protected final Set<MetaFlag> flags;
    protected final boolean unbreakable;
    protected final CompoundBinaryTag nbt;

    public AbstractedItemStack(ItemType type, AbstractStackBuilder<?, ?> builder) {
        this.type = type;
        this.title = builder.title;
        this.lore = ImmutableList.copyOf(builder.lore);
        this.quantity = builder.quantity;
        this.enchantments = ImmutableSet.copyOf(builder.enchantments);
        this.flags = ImmutableSet.copyOf(builder.flags);
        this.unbreakable = builder.unbreakable;
        this.nbt = builder.customModelData != null ? (CompoundBinaryTag)builder.nbt.put("CustomModelData", (BinaryTag)IntBinaryTag.intBinaryTag((int)builder.customModelData)) : builder.nbt;
    }

    @Override
    public ItemType type() {
        return this.type;
    }

    @Override
    public Component title() {
        return this.title;
    }

    @Override
    public List<Component> lore() {
        return this.lore;
    }

    @Override
    public int quantity() {
        return this.quantity;
    }

    @Override
    public Set<Enchantment> enchantments() {
        return this.enchantments;
    }

    @Override
    public Set<MetaFlag> flags() {
        return this.flags;
    }

    @Override
    public boolean unbreakable() {
        return this.unbreakable;
    }

    @Override
    public CompoundBinaryTag nbt() {
        return this.nbt != null ? this.nbt : CompoundBinaryTag.empty();
    }
}

