/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.items;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.items.builders.provided.BasicItemStackBuilder;
import net.impactdev.impactor.api.items.builders.provided.BookStackBuilder;
import net.impactdev.impactor.api.items.builders.provided.SkullStackBuilder;
import net.impactdev.impactor.api.items.properties.MetaFlag;
import net.impactdev.impactor.api.items.properties.enchantments.Enchantment;
import net.impactdev.impactor.api.items.types.ItemType;
import net.impactdev.impactor.api.items.types.ItemTypes;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public interface ImpactorItemStack {
    public static ImpactorItemStack empty() {
        return (ImpactorItemStack)((BasicItemStackBuilder)ImpactorItemStack.basic().type(ItemTypes.AIR).quantity(0)).build();
    }

    public static BasicItemStackBuilder basic() {
        return Impactor.instance().builders().provide(BasicItemStackBuilder.class);
    }

    public static SkullStackBuilder skull() {
        return Impactor.instance().builders().provide(SkullStackBuilder.class);
    }

    public static BookStackBuilder book() {
        return Impactor.instance().builders().provide(BookStackBuilder.class);
    }

    public ItemType type();

    public Component title();

    public List<Component> lore();

    public int quantity();

    public Set<Enchantment> enchantments();

    public Set<MetaFlag> flags();

    public boolean unbreakable();

    default public Optional<Integer> customModelData() {
        @Nullable BinaryTag tag = this.nbt().get("CustomModelData");
        if (tag != null && tag.type().test(BinaryTagTypes.INT)) {
            return Optional.of(((IntBinaryTag)tag).value());
        }
        return Optional.empty();
    }

    public CompoundBinaryTag nbt();
}

