/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.logging;

import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.impactdev.impactor.api.logging.PluginLogger;

public class JavaLogger
implements PluginLogger {
    private final Logger delegate;
    private final Function<String, String> colorizer = in -> in.replaceAll("&", "\u00a7");

    public JavaLogger(Logger delegate) {
        this.delegate = delegate;
    }

    @Override
    public void info(String line) {
        this.delegate.info(this.colorizer.apply(line));
    }

    @Override
    public void warn(String line) {
        this.delegate.warning(this.colorizer.apply(line));
    }

    @Override
    public void warn(String line, Throwable throwable) {
        this.delegate.log(Level.WARNING, line, throwable);
    }

    @Override
    public void severe(String line) {
        this.delegate.severe(this.colorizer.apply(line));
    }

    @Override
    public void severe(String line, Throwable throwable) {
        this.delegate.log(Level.SEVERE, line, throwable);
    }

    @Override
    public void debug(String line) {
        this.delegate.info(this.colorizer.apply("Debug - " + line));
    }
}

