/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.mail.filters;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import net.impactdev.impactor.api.mail.filters.MailFilter;
import org.jetbrains.annotations.Nullable;

public final class MailFilters {
    static MailFilter createSenderFilter(boolean includeConsole, UUID ... players) {
        return MailFilters.createSenderFilter(includeConsole, Arrays.asList(players));
    }

    static MailFilter createSenderFilter(boolean includeConsole, Collection<UUID> players) {
        return m -> m.source().map(players::contains).orElse(includeConsole);
    }

    static MailFilter createDateFilter(@Nullable Instant after, @Nullable Instant before) {
        Preconditions.checkArgument((after != null || before != null ? 1 : 0) != 0);
        Instant iAfter = after == null ? Instant.ofEpochMilli(0L) : after;
        Instant iBefore = before == null ? Instant.now() : before;
        return m -> iAfter.isBefore(m.timestamp()) && iBefore.isAfter(m.timestamp());
    }
}

