/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.scheduler;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import net.impactdev.impactor.api.Impactor;

public interface Ticks {
    public static Ticks zero() {
        return Impactor.instance().factories().provide(Factory.class).zero();
    }

    public static Ticks single() {
        return Impactor.instance().factories().provide(Factory.class).single();
    }

    public static Ticks minecraftHour() {
        return Impactor.instance().factories().provide(Factory.class).minecraftHour();
    }

    public static Ticks minecraftDay() {
        return Impactor.instance().factories().provide(Factory.class).minecraftDay();
    }

    public static Ticks of(long ticks) {
        return Impactor.instance().factories().provide(Factory.class).of(ticks);
    }

    public static Ticks ofWallClockTime(long time, TemporalUnit temporalUnit) {
        return Impactor.instance().factories().provide(Factory.class).ofWallClockTime(time, temporalUnit);
    }

    public static Ticks ofWallClockSeconds(int seconds) {
        return Ticks.ofWallClockTime(seconds, ChronoUnit.SECONDS);
    }

    public static Ticks ofWallClockMinutes(int minutes) {
        return Ticks.ofWallClockTime(minutes, ChronoUnit.MINUTES);
    }

    public static Ticks ofWallClockHours(int hours) {
        return Ticks.ofWallClockTime(hours, ChronoUnit.HOURS);
    }

    public static Ticks ofWallClockDays(int days) {
        return Ticks.ofWallClockTime(days, ChronoUnit.DAYS);
    }

    public static Ticks ofMinecraftSeconds(long seconds) {
        return Impactor.instance().factories().provide(Factory.class).ofMinecraftSeconds(seconds);
    }

    public static Ticks ofMinecraftMinutes(long minutes) {
        return Impactor.instance().factories().provide(Factory.class).ofMinecraftSeconds(minutes * 60L);
    }

    public static Ticks ofMinecraftHours(long hours) {
        return Ticks.ofMinecraftMinutes(hours * 60L);
    }

    public static Ticks ofMinecraftDays(long days) {
        return Ticks.ofMinecraftHours(days * 24L);
    }

    public Duration expectedDuration();

    public long ticks();

    public long minecraftSeconds();

    public Duration minecraftDayTimeDuration();

    public static interface Factory {
        public Ticks of(long var1);

        public Ticks ofWallClockTime(long var1, TemporalUnit var3);

        public Ticks ofMinecraftSeconds(long var1);

        public Ticks ofMinecraftHours(long var1);

        public Ticks zero();

        public Ticks single();

        public Ticks minecraftHour();

        public Ticks minecraftDay();
    }
}

