/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.scoreboards.score;

import java.util.function.IntUnaryOperator;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.annotations.Minecraft;
import net.impactdev.impactor.api.scoreboards.score.ScoreFormatter;
import net.impactdev.impactor.api.utility.Lockable;
import net.impactdev.impactor.api.utility.builders.Builder;
import org.jetbrains.annotations.Nullable;

public interface Score
extends Lockable {
    public static Score of(int value) {
        return Score.of(value, null, false);
    }

    public static Score of(int value, @Nullable ScoreFormatter formatter) {
        return Score.of(value, formatter, false);
    }

    public static Score of(int value, boolean locked) {
        return Score.of(value, null, locked);
    }

    public static Score of(int value, @Nullable ScoreFormatter formatter, boolean locked) {
        return (Score)Score.builder().score(value).formatter(formatter).locked(locked).build();
    }

    public int value();

    @Minecraft(value="1.20.3")
    @Nullable
    public ScoreFormatter formatter();

    public static ScoreBuilder builder() {
        return Impactor.instance().builders().provide(ScoreBuilder.class);
    }

    public static interface ScoreBuilder
    extends Builder<Score> {
        public ScoreBuilder score(int var1);

        @Minecraft(value="1.20.3")
        public ScoreBuilder formatter(ScoreFormatter var1);

        public ScoreBuilder locked(boolean var1);
    }

    public static interface Mutable
    extends Score,
    Lockable.Mutable {
        public boolean update(IntUnaryOperator var1);

        public boolean set(int var1);
    }
}

