/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.text.components;

import com.google.common.base.Strings;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentBuilderApplicable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

public final class ProgressBarComponent
implements ComponentLike,
ComponentBuilderApplicable {
    private final float value;
    private final float max;
    private final int size;
    private final char character;
    private final TextColor filled;
    private final TextColor background;
    private final Style style;

    private ProgressBarComponent(ProgressComponentBuilder builder) {
        this.value = builder.value;
        this.max = builder.max;
        this.size = builder.size;
        this.character = builder.character;
        this.filled = builder.filled;
        this.background = builder.background;
        this.style = builder.style;
    }

    @NotNull
    public Component asComponent() {
        double percentage = this.value / this.max;
        int size = (int)((double)this.size * percentage);
        BuildableComponent result = ((TextComponent.Builder)Component.text().style(this.style)).build();
        String character = String.valueOf(this.character);
        result = result.append(Component.text((String)Strings.repeat((String)character, (int)size)).color(this.filled));
        return result.append(Component.text((String)Strings.repeat((String)character, (int)(this.size - size))).color(this.background));
    }

    public void componentBuilderApply(@NotNull ComponentBuilder<?, ?> builder) {
        builder.append(this.asComponent());
    }

    public static ProgressComponentBuilder builder() {
        return new ProgressComponentBuilder();
    }

    public static final class ProgressComponentBuilder
    implements Builder<ProgressBarComponent> {
        private float value;
        private float max;
        private int size;
        private char character;
        private TextColor filled;
        private TextColor background;
        private Style style = Style.empty();

        public ProgressComponentBuilder value(float value) {
            this.value = value;
            return this;
        }

        public ProgressComponentBuilder max(float max) {
            this.max = max;
            return this;
        }

        public ProgressComponentBuilder size(int size) {
            this.size = size;
            return this;
        }

        public ProgressComponentBuilder character(char character) {
            this.character = character;
            return this;
        }

        public ProgressComponentBuilder filled(TextColor color) {
            this.filled = color;
            return this;
        }

        public ProgressComponentBuilder background(TextColor color) {
            this.background = color;
            return this;
        }

        public ProgressComponentBuilder style(Style style) {
            this.style = style;
            return this;
        }

        @Override
        public ProgressBarComponent build() {
            return new ProgressBarComponent(this);
        }
    }
}

