/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.text.mini;

import java.util.Objects;
import java.util.stream.Stream;
import net.impactdev.impactor.api.text.mini.AbstractImpactorColorChangingTag;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.util.HSVLike;
import net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class FadeTag
extends AbstractImpactorColorChangingTag {
    private static final String FADE = "fade";
    public static final TagResolver RESOLVER = TagResolver.resolver((String)"fade", FadeTag::create);
    private final int steps;
    private final int gap;
    private int phase;

    private static Tag create(@NotNull ArgumentQueue queue, Context context) {
        int steps = queue.popOr("Steps not specified").asInt().orElseThrow(() -> new IllegalArgumentException("Invalid steps configuration"));
        int gap = queue.popOr("Gap not specified").asInt().orElseThrow(() -> new IllegalArgumentException("Invalid gap configuration"));
        Tag.Argument phase = queue.peek();
        if (phase != null) {
            return new FadeTag(steps, gap, phase.asInt().orElseThrow(() -> new IllegalArgumentException("Invalid index configuration")));
        }
        return new FadeTag(steps, gap, 0);
    }

    private FadeTag(int steps, int gap, int phase) {
        this.steps = steps;
        this.gap = gap;
        this.phase = phase;
    }

    @Override
    protected void init() {
    }

    @Override
    protected void advanceColor() {
        this.phase = (this.phase + this.gap) % 360;
    }

    @Override
    protected TextColor color() {
        int hue = (this.phase + this.gap) % 360;
        int spacer = 360 / this.steps;
        HSVLike hsv = HSVLike.hsvLike((float)((float)(hue + this.phase * spacer) % 360.0f / 360.0f), (float)1.0f, (float)1.0f);
        return TextColor.color((HSVLike)hsv);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"phase", (int)this.phase), ExaminableProperty.of((String)"steps", (int)this.steps), ExaminableProperty.of((String)"gap", (int)this.gap));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FadeTag fadeTag = (FadeTag)o;
        return this.steps == fadeTag.steps && this.gap == fadeTag.gap && this.phase == fadeTag.phase;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.steps, this.gap, this.phase);
    }
}

