/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.text.placeholders;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaceholderArguments {
    private final List<String> arguments = new LinkedList<String>();
    private int index;

    public PlaceholderArguments(String[] arguments) {
        this.arguments.addAll(Arrays.asList(arguments));
    }

    private PlaceholderArguments() {
    }

    public static PlaceholderArguments create(ArgumentQueue queue) {
        PlaceholderArguments result = new PlaceholderArguments();
        while (queue.hasNext()) {
            result.arguments.add(queue.pop().value());
        }
        return result;
    }

    @NotNull
    public String pop() {
        if (this.index >= this.arguments.size()) {
            throw new IllegalStateException("No available element in argument list");
        }
        return this.arguments.get(this.index++);
    }

    @Nullable
    public String popOrDefault() {
        if (this.index >= this.arguments.size()) {
            return null;
        }
        return this.arguments.get(this.index++);
    }

    @Nullable
    public String peek() {
        if (this.index >= this.arguments.size()) {
            return null;
        }
        return this.arguments.get(this.index);
    }

    public boolean hasNext() {
        return this.arguments.size() > this.index;
    }

    public void reset() {
        this.index = 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaceholderArguments that = (PlaceholderArguments)o;
        return Objects.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.arguments);
    }
}

