/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.text.transforming.transformers;

import net.impactdev.impactor.api.text.transforming.transformers.ColorAlteringTransformer;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;

public final class FadeTransformer
extends ColorAlteringTransformer {
    private final int steps;
    private final int gap;
    private int start;
    private int phase;

    public static FadeTransformer create(int steps, int gap, int start) {
        return new FadeTransformer(steps, gap, start);
    }

    private FadeTransformer(int steps, int gap, int start) {
        this.steps = steps;
        this.gap = gap;
        this.phase = start;
    }

    @Override
    protected void advance() {
        this.phase = (this.phase + this.gap) % 360;
    }

    @Override
    protected TextColor color() {
        int hue = this.phase % 360;
        int spacer = 360 / this.steps;
        HSVLike hsv = HSVLike.hsvLike((float)((float)(hue + this.phase * spacer) % 360.0f / 360.0f), (float)1.0f, (float)1.0f);
        return TextColor.color((HSVLike)hsv);
    }

    @Override
    public void step() {
        this.start += this.gap;
        this.phase = this.start;
    }
}

