/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.translations;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.text.TextProcessor;
import net.impactdev.impactor.api.translations.repository.TranslationRepository;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface TranslationManager {
    public static Locale parseLocale(String input) {
        return Translator.parseLocale((String)input);
    }

    public void initialize();

    public TranslationRepository repository();

    public void reload();

    public void refresh();

    public TextProcessor processor();

    public Locale defaultLocale();

    public Set<Locale> installed();

    public Path root();

    public static TranslationManagerBuilder builder() {
        return Impactor.instance().builders().provide(TranslationManagerBuilder.class);
    }

    public static interface TranslationManagerBuilder
    extends Builder<TranslationManager> {
        @Contract(value="_ -> this")
        @CanIgnoreReturnValue
        public TranslationManagerBuilder repository(@NotNull TranslationRepository var1);

        @Contract(value="_ -> this")
        @CanIgnoreReturnValue
        public TranslationManagerBuilder fallback(@NotNull Locale var1);

        @Contract(value="_ -> this")
        @CanIgnoreReturnValue
        public TranslationManagerBuilder path(@NotNull Path var1);

        @Contract(value="_ -> this")
        @CanIgnoreReturnValue
        public TranslationManagerBuilder processor(@NotNull TextProcessor var1);

        @Contract(value="_ -> this")
        @CanIgnoreReturnValue
        public TranslationManagerBuilder provided(@NotNull Supplier<InputStream> var1);
    }
}

