/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.translations.metadata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.impactdev.impactor.api.translations.TranslationManager;

public final class LanguageInfo {
    private final String id;
    private final String name;
    private final Locale locale;
    private final int progress;
    private final List<String> contributors;

    public LanguageInfo(String id, JsonObject data) {
        this.id = id;
        this.name = data.get("name").getAsString();
        this.locale = Objects.requireNonNull(TranslationManager.parseLocale(data.get("id").getAsString()));
        this.progress = data.get("progress").getAsInt();
        this.contributors = new ArrayList<String>();
        for (JsonElement contributor : data.get("contributors").getAsJsonArray()) {
            this.contributors.add(contributor.getAsJsonObject().get("name").getAsString());
        }
    }

    private LanguageInfo(String id, String name, Locale locale, int progress, List<String> contributors) {
        this.id = id;
        this.name = name;
        this.locale = locale;
        this.progress = progress;
        this.contributors = contributors;
    }

    public static LanguageInfo create(String id, String name, Locale locale, int progress, List<String> contributors) {
        return new LanguageInfo(id, name, locale, progress, contributors);
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Locale locale() {
        return this.locale;
    }

    public int progress() {
        return this.progress;
    }

    public List<String> contributors() {
        return this.contributors;
    }
}

