/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.translations.repository;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.translations.metadata.LanguageInfo;
import net.impactdev.impactor.api.translations.repository.TranslationEndpoint;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.kyori.adventure.audience.Audience;
import org.jetbrains.annotations.NotNull;

public interface TranslationRepository {
    public CompletableFuture<Set<LanguageInfo>> available();

    public CompletableFuture<Boolean> refresh();

    default public CompletableFuture<Void> downloadAndInstall(@NotNull Set<LanguageInfo> languages, boolean update) {
        return this.downloadAndInstall(languages, Audience.empty(), update);
    }

    public CompletableFuture<Void> downloadAndInstall(@NotNull Set<LanguageInfo> var1, @NotNull Audience var2, boolean var3);

    public static RepositoryBuilder builder() {
        return Impactor.instance().builders().provide(RepositoryBuilder.class);
    }

    public static interface RepositoryBuilder
    extends Builder<TranslationRepository> {
        public RepositoryBuilder endpoint(@NotNull TranslationEndpoint var1, @NotNull String var2);

        public RepositoryBuilder refreshWhen(@NotNull Supplier<Boolean> var1);

        public RepositoryBuilder maxBundleSize(long var1);

        public RepositoryBuilder maxCacheAge(long var1);
    }
}

