/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.utility;

import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Time {
    private long time;
    private static final int secondsPerMinute = 60;
    private static final int secondsPerHour = 3600;
    private static final int secondsPerDay = 86400;
    private static final int secondsPerWeek = 604800;

    public Time(long seconds) {
        this.time = seconds;
    }

    public Time(String formattedTime) throws IllegalArgumentException {
        Pattern minorTimeString = Pattern.compile("^\\d+$");
        Pattern timeString = Pattern.compile("^((\\d+)w)?((\\d+)d)?((\\d+)h)?((\\d+)m)?((\\d+)s)?$");
        if (minorTimeString.matcher(formattedTime).matches()) {
            this.time += Long.parseUnsignedLong(formattedTime);
            return;
        }
        Matcher m = timeString.matcher(formattedTime);
        if (m.matches()) {
            this.time = this.amount(m.group(2), 604800);
            this.time += this.amount(m.group(4), 86400);
            this.time += this.amount(m.group(6), 3600);
            this.time += this.amount(m.group(8), 60);
            this.time += this.amount(m.group(10), 1);
        }
    }

    private long amount(String g, int multiplier) {
        if (g != null && g.length() > 0) {
            return (long)multiplier * Long.parseUnsignedLong(g);
        }
        return 0L;
    }

    public long getTime() {
        return this.time;
    }

    public String asShort() {
        if (this.time < 60L) {
            return this.time + "s";
        }
        if (this.time < 3600L) {
            return TimeUnit.SECONDS.toMinutes(this.time) + "m";
        }
        return TimeUnit.SECONDS.toHours(this.time) + "h";
    }

    public String asPatternized() {
        if (this.time <= 0L) {
            return "Expired";
        }
        StringJoiner joiner = new StringJoiner(" ");
        long weeks = TimeUnit.SECONDS.toDays(this.time) / 7L;
        long days = TimeUnit.SECONDS.toDays(this.time) % 7L;
        long hours = TimeUnit.SECONDS.toHours(this.time) % 24L;
        long minutes = TimeUnit.SECONDS.toMinutes(this.time) % 60L;
        long seconds = this.time % 60L;
        if (weeks > 0L) {
            joiner.add(weeks + "w");
        }
        if (days > 0L) {
            joiner.add(days + "d");
        }
        if (hours > 0L) {
            joiner.add(hours + "h");
        }
        if (minutes > 0L) {
            joiner.add(minutes + "m");
        }
        if (seconds > 0L) {
            joiner.add(seconds + "s");
        }
        return joiner.toString();
    }

    public String toString() {
        if (this.time <= 0L) {
            return "Expired";
        }
        return String.format("%02d:%02d:%02d", TimeUnit.SECONDS.toHours(this.time), TimeUnit.SECONDS.toMinutes(this.time) % 60L, this.time % 60L);
    }
}

