/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.utility.collections.lists;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.impactdev.impactor.api.utility.collections.lists.Node;
import org.jetbrains.annotations.NotNull;

public class CircularLinkedList<E>
implements Iterable<E> {
    private Node<E> head;
    private Node<E> tail;
    private Node<E> current;

    @SafeVarargs
    public static <E> CircularLinkedList<E> of(E ... elements) {
        CircularLinkedList<E> list = new CircularLinkedList<E>();
        for (E element : elements) {
            list.append(element);
        }
        return list;
    }

    public static <E> CircularLinkedList<E> fromStream(Stream<E> stream) {
        CircularLinkedList<E> result = new CircularLinkedList<E>();
        stream.forEach(result::append);
        return result;
    }

    public E current() {
        return this.current.value();
    }

    public E currentThenAdvance() {
        Node<E> node = this.current;
        this.current = this.current.next;
        return node.value();
    }

    public E next() {
        this.current = this.current.next;
        return this.current.value();
    }

    public void advanceTo(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.size() ? 1 : 0) != 0, (Object)"Invalid index position");
        Node<E> target = this.head;
        for (int i = 1; i <= index; ++i) {
            target = target.next;
        }
        this.current = target;
    }

    public void append(E value) {
        Node<E> node = new Node<E>(value);
        if (this.head == null) {
            this.head = node;
            this.head.next = this.head;
            this.current = node;
        } else {
            this.tail.next = node;
        }
        this.tail = node;
        this.tail.next = this.head;
    }

    public List<E> asList() {
        ArrayList output = Lists.newArrayList();
        Node<E> working = this.head;
        while (working != null) {
            output.add(working.value());
            working = working.next;
            if (!Objects.equals(this.head.value(), working.value())) continue;
            break;
        }
        return output;
    }

    public boolean empty() {
        return this.asList().isEmpty();
    }

    public int size() {
        return this.asList().size();
    }

    public E at(int index) throws IndexOutOfBoundsException {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        Node<E> node = this.head;
        for (int i = 0; i < index; ++i) {
            node = node.next;
        }
        return node.value();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.asList().iterator();
    }
}

