/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.commands;

import io.leangen.geantyref.TypeToken;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.api.commands.ImpactorCommandManager;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.core.commands.events.RegisterCommandsEvent;
import net.impactdev.impactor.core.commands.parsers.ActivePaginationParser;
import net.impactdev.impactor.core.commands.parsers.CurrencyParser;
import net.impactdev.impactor.core.commands.parsers.LocaleParser;
import net.impactdev.impactor.core.commands.parsers.PlatformSourceParser;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.text.pagination.ActivePagination;
import net.impactdev.impactor.core.utility.events.EventPublisher;
import net.impactdev.impactor.relocations.io.github.classgraph.ClassGraph;
import net.impactdev.impactor.relocations.io.github.classgraph.ClassInfo;
import net.impactdev.impactor.relocations.io.github.classgraph.ClassInfoList;
import net.impactdev.impactor.relocations.io.github.classgraph.ScanResult;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.annotations.processing.CommandContainer;
import org.incendo.cloud.component.DefaultValue;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.help.result.CommandEntry;
import org.incendo.cloud.meta.CommandMeta;
import org.incendo.cloud.minecraft.extras.AudienceProvider;
import org.incendo.cloud.minecraft.extras.ImmutableMinecraftHelp;
import org.incendo.cloud.minecraft.extras.MinecraftHelp;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.SuggestionProvider;

public final class ImpactorCommandRegistry {
    private final ImpactorCommandManager manager = ImpactorCommandManager.create(BaseImpactorPlugin.instance().metadata(), BaseImpactorPlugin.instance().logger());

    public ImpactorCommandManager manager() {
        return this.manager;
    }

    public void registerAllCommands() {
        AnnotationParser<CommandSource> parser = this.createParser();
        EventPublisher.post(new RegisterCommandsEvent(parser));
        ImmutableMinecraftHelp helper = MinecraftHelp.builder().commandManager(this.manager.delegate()).audienceProvider(AudienceProvider.nativeAudience()).commandPrefix("/impactor help").build();
        this.manager().delegate().command(this.manager().delegate().commandBuilder("impactor", new String[0]).literal("help", new String[0]).optional("query", StringParser.greedyStringParser(), DefaultValue.constant((Object)""), SuggestionProvider.blocking((ctx, in) -> this.manager.delegate().createHelpHandler().queryRootIndex((Object)((CommandSource)ctx.sender())).entries().stream().map(CommandEntry::syntax).map(Suggestion::simple).collect(Collectors.toList()))).handler(arg_0 -> ImpactorCommandRegistry.lambda$registerAllCommands$1((MinecraftHelp)helper, arg_0)));
    }

    public void registerArgumentParsers() {
        this.manager.delegate().parserRegistry().registerParserSupplier(TypeToken.get(Currency.class), options -> new CurrencyParser());
        this.manager.delegate().parserRegistry().registerParserSupplier(TypeToken.get(PlatformSource.class), options -> new PlatformSourceParser());
        this.manager.delegate().parserRegistry().registerParserSupplier(TypeToken.get(Locale.class), options -> new LocaleParser());
        this.manager.delegate().parserRegistry().registerParserSupplier(TypeToken.get(ActivePagination.class), options -> new ActivePaginationParser());
    }

    private AnnotationParser<CommandSource> createParser() {
        AnnotationParser parser = new AnnotationParser(this.manager.delegate(), CommandSource.class, parameters -> CommandMeta.empty());
        return parser;
    }

    private List<Class<?>> collectCommandContainers(Impactor service) {
        ClassGraph graph = new ClassGraph().acceptPackages("net.impactdev.impactor").enableClassInfo().enableAnnotationInfo().overrideClassLoaders(this.getClass().getClassLoader());
        ScanResult scan = graph.scan();
        try {
            ClassInfoList list = scan.getClassesWithAnnotation(CommandContainer.class);
            List<Class<?>> list2 = list.stream().map(ClassInfo::loadClass).collect(Collectors.toList());
            if (scan != null) {
                scan.close();
            }
            return list2;
        }
        catch (Throwable throwable) {
            try {
                if (scan != null) {
                    try {
                        scan.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
    }

    private static /* synthetic */ void lambda$registerAllCommands$1(MinecraftHelp helper, CommandContext context) {
        helper.queryCommands(Objects.requireNonNull((String)context.get("query")), (Object)((CommandSource)context.sender()));
    }
}

