/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.commands.economy;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.api.configuration.Config;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.EconomyTransferTransaction;
import net.impactdev.impactor.api.economy.transactions.details.EconomyResultType;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.services.permissions.PermissionsService;
import net.impactdev.impactor.api.utility.Context;
import net.impactdev.impactor.core.economy.EconomyConfig;
import net.impactdev.impactor.core.economy.ImpactorEconomyService;
import net.impactdev.impactor.core.economy.context.TransactionContext;
import net.impactdev.impactor.core.economy.context.TransferTransactionContext;
import net.impactdev.impactor.core.translations.internal.ImpactorTranslations;
import net.kyori.adventure.util.TriState;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.CommandDescription;
import org.incendo.cloud.annotations.Flag;
import org.incendo.cloud.annotations.Permission;
import org.incendo.cloud.annotations.ProxiedBy;
import org.incendo.cloud.annotations.processing.CommandContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CommandContainer
@Permission(value={"impactor.commands.economy.base"})
public final class EconomyCommands {
    @Command(value="economy|eco balance [currency] [target]")
    @ProxiedBy(value="balance")
    @Permission(value={"impactor.commands.economy.balance"})
    @CommandDescription(value="Fetches the balance of the source or identified target")
    public void balance(@NotNull CommandSource source2, @Argument(value="target") @Nullable PlatformSource target, @Argument(value="currency") @Nullable Currency currency) {
        EconomyService service = EconomyService.instance();
        Currency c = currency != null ? currency : service.currencies().primary();
        PlatformSource focus = target != null ? target : source2.source();
        Account account = service.account(c, focus.uuid()).join();
        Context context = Context.empty();
        context.append(Currency.class, c);
        context.append(Account.class, account);
        ImpactorTranslations.ECONOMY_BALANCE.send(source2, context);
    }

    @Command(value="economy|eco withdraw <amount> [currency] [target]")
    @ProxiedBy(value="withdraw")
    @Permission(value={"impactor.commands.economy.withdraw"})
    public void withdraw(@NotNull CommandSource source2, @Argument(value="amount") double amount, @Argument(value="target") @Nullable PlatformSource target, @Argument(value="currency") @Nullable Currency currency) {
        EconomyService service = EconomyService.instance();
        Currency c = currency != null ? currency : service.currencies().primary();
        PlatformSource focus = target != null ? target : source2.source();
        service.account(c, focus.uuid()).thenAccept(account -> {
            BigDecimal before = account.balance();
            EconomyTransaction transaction = account.withdraw(new BigDecimal(amount));
            Context context = Context.empty();
            context.append(TransactionContext.class, new TransactionContext(EconomyTransactionType.WITHDRAW, before, account.balance(), transaction.result()));
            context.append(Currency.class, c);
            context.append(Account.class, account);
            if (!transaction.successful()) {
                ImpactorTranslations.ECONOMY_TRANSACTION_FAILED.send(source2, context);
            } else {
                ImpactorTranslations.ECONOMY_TRANSACTION.send(source2, context);
            }
        });
    }

    @Command(value="economy|eco deposit <amount> [currency] [target]")
    @ProxiedBy(value="deposit")
    @Permission(value={"impactor.commands.economy.deposit"})
    public void deposit(@NotNull CommandSource source2, @Argument(value="amount") double amount, @Argument(value="target") @Nullable PlatformSource target, @Argument(value="currency") @Nullable Currency currency) {
        EconomyService service = EconomyService.instance();
        Currency c = currency != null ? currency : service.currencies().primary();
        PlatformSource focus = target != null ? target : source2.source();
        service.account(c, focus.uuid()).thenAccept(account -> {
            BigDecimal before = account.balance();
            EconomyTransaction transaction = account.deposit(new BigDecimal(amount));
            Context context = Context.empty();
            context.append(TransactionContext.class, new TransactionContext(EconomyTransactionType.DEPOSIT, before, account.balance(), transaction.result()));
            context.append(Currency.class, c);
            context.append(Account.class, account);
            if (!transaction.successful()) {
                ImpactorTranslations.ECONOMY_TRANSACTION_FAILED.send(source2, context);
            } else {
                ImpactorTranslations.ECONOMY_TRANSACTION.send(source2, context);
            }
        });
    }

    @Command(value="economy|eco set <amount> [currency] [target]")
    @Permission(value={"impactor.commands.economy.set"})
    public void set(@NotNull CommandSource source2, @Argument(value="amount") double amount, @Argument(value="target") @Nullable PlatformSource target, @Argument(value="currency") @Nullable Currency currency) {
        EconomyService service = EconomyService.instance();
        Currency c = currency != null ? currency : service.currencies().primary();
        PlatformSource focus = target != null ? target : source2.source();
        service.account(c, focus.uuid()).thenAccept(account -> {
            BigDecimal before = account.balance();
            EconomyTransaction transaction = account.set(new BigDecimal(amount));
            Context context = Context.empty();
            context.append(TransactionContext.class, new TransactionContext(EconomyTransactionType.SET, before, account.balance(), transaction.result()));
            context.append(Currency.class, c);
            context.append(Account.class, account);
            if (!transaction.successful()) {
                ImpactorTranslations.ECONOMY_TRANSACTION_FAILED.send(source2, context);
            } else {
                ImpactorTranslations.ECONOMY_TRANSACTION.send(source2, context);
            }
        });
    }

    @Command(value="economy|eco reset [currency] [target]")
    @Permission(value={"impactor.commands.economy.reset"})
    public void reset(@NotNull CommandSource source2, @Argument(value="target") @Nullable PlatformSource target, @Argument(value="currency") @Nullable Currency currency) {
        EconomyService service = EconomyService.instance();
        Currency c = currency != null ? currency : service.currencies().primary();
        PlatformSource focus = target != null ? target : source2.source();
        service.account(c, focus.uuid()).thenAccept(account -> {
            BigDecimal before = account.balance();
            EconomyTransaction transaction = account.reset();
            Context context = Context.empty();
            context.append(TransactionContext.class, new TransactionContext(EconomyTransactionType.RESET, before, account.balance(), transaction.result()));
            context.append(Currency.class, c);
            context.append(Account.class, account);
            if (!transaction.successful()) {
                ImpactorTranslations.ECONOMY_TRANSACTION_FAILED.send(source2, context);
            } else {
                ImpactorTranslations.ECONOMY_TRANSACTION.send(source2, context);
            }
        });
    }

    @Command(value="economy|eco pay <amount> <target> [currency] [source]")
    @ProxiedBy(value="pay")
    @Permission(value={"impactor.commands.economy.pay.base"})
    public void transfer(@NotNull CommandSource sender, @Argument(value="amount") double amount, @Argument(value="target") PlatformSource target, @Argument(value="currency") @Nullable Currency currency, @Argument(value="source") @Nullable PlatformSource from) {
        EconomyService service = EconomyService.instance();
        Currency c = currency != null ? currency : service.currencies().primary();
        PlatformSource focus = from != null ? from : sender.source();
        Context context = Context.empty();
        context.append(Currency.class, c);
        if (from != null) {
            PermissionsService permissions = Impactor.instance().services().provide(PermissionsService.class);
            if (!permissions.hasPermission(sender.source(), "impactor.commands.economy.pay.other")) {
                ImpactorTranslations.NO_PERMISSION.send(sender, context);
                return;
            }
        } else if (target.uuid().equals(sender.uuid())) {
            ImpactorTranslations.ECONOMY_CANT_PAY_SELF.send(sender, context);
            return;
        }
        if (c.transferable() == TriState.FALSE) {
            ImpactorTranslations.ECONOMY_TRANSFER_NOT_ALLOWED.send(sender, context);
            return;
        }
        Config config = ((ImpactorEconomyService)service).config();
        if (c.transferable() == TriState.NOT_SET && !config.get(EconomyConfig.ALLOW_TRANSFER_ON_NOT_SET).booleanValue()) {
            ImpactorTranslations.ECONOMY_TRANSFER_NOT_ALLOWED.send(sender, context);
            return;
        }
        service.account(c, focus.uuid()).thenAccept(s -> {
            Account to = service.account(c, target.uuid()).join();
            BigDecimal sb = s.balance();
            BigDecimal tb = to.balance();
            BigDecimal total = new BigDecimal(amount);
            EconomyTransferTransaction transaction = EconomyTransferTransaction.compose().to(to).from((Account)s).amount(total).message(EconomyResultType.NOT_ENOUGH_FUNDS, () -> ImpactorTranslations.ECONOMY_TRANSACTION_FAILED.resolve(sender.locale(), context)).message(EconomyResultType.INVALID, () -> ImpactorTranslations.ECONOMY_TRANSACTION_FAILED.resolve(sender.locale(), context)).message(EconomyResultType.FAILED, () -> ImpactorTranslations.ECONOMY_TRANSACTION_FAILED.resolve(sender.locale(), context)).message(EconomyResultType.SUCCESS, () -> ImpactorTranslations.ECONOMY_TRANSFER.resolve(sender.locale(), context)).build();
            context.append(TransferTransactionContext.class, new TransferTransactionContext(new TransactionContext(EconomyTransactionType.WITHDRAW, sb, s.balance(), transaction.result()), new TransactionContext(EconomyTransactionType.DEPOSIT, tb, to.balance(), transaction.result()), transaction.result()));
            transaction.inform(sender);
            if (!target.equals(focus) && transaction.successful()) {
                context.append(PlatformSource.class, sender.source());
                context.append(BigDecimal.class, total);
                ImpactorTranslations.ECONOMY_RECEIVE_PAYMENT.send(target, context);
            }
        });
    }

    @Command(value="economy|eco baltop")
    @ProxiedBy(value="baltop")
    @Permission(value={"impactor.commands.economy.baltop"})
    public void baltop(CommandSource source2, @Flag(value="currency") @Nullable Currency currency, @Flag(value="extended") boolean nonPlayers) {
        EconomyService service = EconomyService.instance();
        Currency target = currency != null ? currency : service.currencies().primary();
        AtomicInteger max = new AtomicInteger(10);
        if (service instanceof ImpactorEconomyService) {
            Config config = ((ImpactorEconomyService)service).config();
            max.set(config.get(EconomyConfig.MAX_BALTOP_ENTRIES));
        }
        ImpactorTranslations.ECONOMY_BALTOP_CALCULATING.send(source2, Context.empty());
        service.accounts(target).thenAccept(accounts -> {
            Context context = Context.empty().append(Currency.class, target);
            ImpactorTranslations.ECONOMY_BALTOP_HEADER.send(source2, context);
            AtomicInteger ranking = new AtomicInteger(1);
            accounts.stream().sorted(Comparator.comparing(Account::balance).reversed()).filter(account -> !account.virtual() || nonPlayers).limit(max.get()).forEach(account -> {
                Context relative = Context.empty().with(context).append(Account.class, account).append(Integer.class, Integer.valueOf(ranking.getAndIncrement()));
                ImpactorTranslations.ECONOMY_BALTOP_ENTRY.send(source2, relative);
            });
            ImpactorTranslations.ECONOMY_BALTOP_FOOTER.send(source2, context);
        });
    }
}

