/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.commands.parsers;

import com.google.common.base.Suppliers;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.core.text.pagination.ActivePagination;
import net.impactdev.impactor.core.text.pagination.PaginationService;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.jetbrains.annotations.Nullable;

public class ActivePaginationParser
implements ArgumentParser<CommandSource, ActivePagination> {
    private static final Supplier<PaginationService> SERVICE = Suppliers.memoize(() -> Impactor.instance().services().provide(PaginationService.class));
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$");

    public @NonNull ArgumentParseResult<@NonNull ActivePagination> parse(@NonNull CommandContext<@NonNull CommandSource> context, @NonNull CommandInput input) {
        String argument = input.peekString();
        Matcher matcher = UUID_PATTERN.matcher(argument);
        if (matcher.matches()) {
            UUID uuid = UUID.fromString(argument);
            PaginationService service = SERVICE.get();
            @Nullable ActivePagination pagination = service.pagination(uuid).orElse(null);
            if (pagination != null) {
                input.readString();
                return ArgumentParseResult.success((Object)pagination);
            }
        }
        return ArgumentParseResult.failure((Throwable)new IllegalArgumentException("No active pagination for that ID"));
    }
}

