/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.commands.parsers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.currency.CurrencyProvider;
import net.impactdev.impactor.core.utility.future.Futures;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.SuggestionProvider;

public final class CurrencyParser
implements ArgumentParser<CommandSource, Currency>,
SuggestionProvider<CommandSource> {
    public @NonNull ArgumentParseResult<@NonNull Currency> parse(@NonNull CommandContext<@NonNull CommandSource> context, @NonNull CommandInput input) {
        String value = input.peekString();
        try {
            Key key = value.contains(":") ? Key.key((String)value) : Key.key((String)"impactor", (String)value);
            return Impactor.instance().services().provide(EconomyService.class).currencies().currency(key).map(currency -> {
                input.readString();
                return currency;
            }).map(ArgumentParseResult::success).orElseGet(() -> ArgumentParseResult.failure((Throwable)new IllegalArgumentException("Bad input: " + input)));
        }
        catch (Exception e) {
            return ArgumentParseResult.failure((Throwable)new IllegalArgumentException("Bad input: " + input));
        }
    }

    public @NonNull CompletableFuture<@NonNull Iterable<@NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<CommandSource> context, @NonNull CommandInput input) {
        String argument = input.peekString();
        return Futures.execute(() -> {
            ArrayList results = Lists.newArrayList();
            CurrencyProvider currencies = Impactor.instance().services().provide(EconomyService.class).currencies();
            currencies.registered().forEach(currency -> {
                if (currency.key().value().startsWith(argument)) {
                    results.add(currency.key().value());
                    results.add(currency.key().asString());
                } else if (currency.key().asString().startsWith(argument)) {
                    results.add(currency.key().asString());
                }
            });
            return results.stream().map(Suggestion::simple).toList();
        });
    }
}

