/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.commands.parsers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.api.translations.TranslationManager;
import net.impactdev.impactor.api.translations.metadata.LanguageInfo;
import net.impactdev.impactor.core.translations.internal.ImpactorTranslations;
import org.apache.commons.lang3.LocaleUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

public class LocaleParser
implements ArgumentParser<CommandSource, Locale>,
BlockingSuggestionProvider<CommandSource> {
    public @NonNull ArgumentParseResult<@NonNull Locale> parse(@NonNull CommandContext<@NonNull CommandSource> context, @NonNull CommandInput input) {
        String argument = input.peekString();
        Locale locale = TranslationManager.parseLocale(argument);
        if (!LocaleUtils.isAvailableLocale((Locale)locale)) {
            return ArgumentParseResult.failure((Throwable)new IllegalArgumentException("Invalid locale: " + input));
        }
        input.readString();
        return ArgumentParseResult.success((Object)locale);
    }

    public @NonNull Iterable<@NonNull Suggestion> suggestions(@NonNull CommandContext<CommandSource> context, @NonNull CommandInput input) {
        ArrayList options = Lists.newArrayList();
        Set<LanguageInfo> available = ImpactorTranslations.MANAGER.repository().available().join();
        available.forEach(info -> {
            if (info.id().toLowerCase().startsWith(input.peekString().toLowerCase())) {
                options.add(Suggestion.simple((String)info.id()));
            }
        });
        return options;
    }
}

