/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import net.impactdev.impactor.api.configuration.key.ConfigKey;
import net.impactdev.impactor.api.configuration.key.ConfigKeyFactory;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.storage.StorageCredentials;
import net.impactdev.impactor.api.storage.StorageType;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;

public final class EconomyConfig {
    public static final ConfigKey<StorageType> STORAGE_TYPE = ConfigKeyFactory.key(adapter -> StorageType.parse(adapter.getString("storage.method", "json")));
    public static final ConfigKey<StorageCredentials> STORAGE_CREDENTIALS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(adapter -> {
        String address = adapter.getString("storage.data.address", "localhost");
        String database = adapter.getString("storage.data.database", "minecraft");
        String username = adapter.getString("storage.data.username", "root");
        String password = adapter.getString("storage.data.password", "");
        int maxPoolSize = adapter.getInteger("storage.data.pool-settings.maximum-pool-size", 10);
        int minIdle = adapter.getInteger("storage.data.pool-settings.minimum-idle", maxPoolSize);
        int maxLifetime = adapter.getInteger("storage.data.pool-settings.maximum-lifetime", 1800000);
        int connectionTimeout = adapter.getInteger("storage.data.pool-settings.connection-timeout", 5000);
        int keepAliveTime = adapter.getInteger("storage.data.pool-settings.keep-alive", 0);
        ImmutableMap props = ImmutableMap.copyOf(adapter.getStringMap("storage.data.pool-settings.properties", (Map<String, String>)ImmutableMap.of()));
        return new StorageCredentials(address, database, username, password, maxPoolSize, minIdle, maxLifetime, keepAliveTime, connectionTimeout, (Map<String, String>)props);
    }));
    public static final ConfigKey<String> SQL_TABLE_PREFIX = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("storage.table-prefix", "economy_"));
    public static final ConfigKey<Boolean> APPLY_RESTRICTIONS = ConfigKeyFactory.booleanKey("restrictions.enabled", true);
    public static final ConfigKey<BigDecimal> MIN_BALANCE = ConfigKeyFactory.key(adapter -> {
        double value = adapter.getDouble("restrictions.minimum-balance", 0.0);
        return BigDecimal.valueOf(value);
    });
    public static final ConfigKey<BigDecimal> MAX_BALANCE = ConfigKeyFactory.key(adapter -> {
        double value = adapter.getDouble("restrictions.maximum-balance", 1.0E11);
        return BigDecimal.valueOf(value);
    });
    public static final ConfigKey<Boolean> ALLOW_TRANSFER_CROSS_CURRENCY = ConfigKeyFactory.booleanKey("restrictions.allow-cross-currency-transfers", false);
    public static final ConfigKey<Boolean> ALLOW_TRANSFER_ON_NOT_SET = ConfigKeyFactory.booleanKey("allow-transfer-for-not-set", false);
    public static final ConfigKey<Integer> MAX_BALTOP_ENTRIES = ConfigKeyFactory.intKey("baltop.max-entries", 10);
    public static final ConfigKey<List<Currency>> CURRENCIES = ConfigKeyFactory.key(adapter -> {
        ArrayList results = Lists.newArrayList();
        for (String option : adapter.getKeys("currencies", Lists.newArrayList((Object[])new String[]{"dollars"}))) {
            StringJoiner joiner = new StringJoiner(".").add("currencies").add(option);
            Function<String, String> modifier = key -> joiner + "." + key;
            Currency.CurrencyBuilder builder = Currency.builder().key(Key.key((String)option)).name((Component)Component.text((String)adapter.getString(modifier.apply("singular"), "Dollar"))).plural((Component)Component.text((String)adapter.getString(modifier.apply("plural"), "Dollars"))).symbol((Component)Component.text((String)adapter.getString(modifier.apply("symbol"), "$"))).formatting(new Currency.CurrencyFormatting(adapter.getString(modifier.apply("formatting.condensed"), "<symbol><amount>"), adapter.getString(modifier.apply("formatting.expanded"), "<amount> <name>"))).decimals(adapter.getInteger(modifier.apply("decimals"), 2)).starting(BigDecimal.valueOf(adapter.getDouble(modifier.apply("default-balance"), 500.0)));
            if (adapter.getBoolean(modifier.apply("primary"), false)) {
                builder.primary();
            }
            builder.transferable(adapter.getBoolean(modifier.apply("transferable"), true));
            results.add((Currency)builder.build());
        }
        return results;
    });
}

