/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy;

import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.composer.TransactionComposer;
import net.impactdev.impactor.api.economy.transactions.composer.TransferComposer;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.providers.BuilderProvider;
import net.impactdev.impactor.core.economy.accounts.ImpactorAccount;
import net.impactdev.impactor.core.economy.currency.ImpactorCurrency;
import net.impactdev.impactor.core.economy.registration.EconomyRegistrationProvider;
import net.impactdev.impactor.core.economy.registration.ImpactorSuggestEconomyServiceEvent;
import net.impactdev.impactor.core.economy.transactions.composers.BaseTransactionComposer;
import net.impactdev.impactor.core.economy.transactions.composers.TransferTransactionComposer;
import net.impactdev.impactor.core.modules.ImpactorModule;

public class EconomyModule
implements ImpactorModule {
    @Override
    public void builders(BuilderProvider provider) {
        provider.register(Currency.CurrencyBuilder.class, ImpactorCurrency.ImpactorCurrencyBuilder::new);
        provider.register(Account.AccountBuilder.class, ImpactorAccount.ImpactorAccountBuilder::new);
        provider.register(TransactionComposer.class, BaseTransactionComposer::new);
        provider.register(TransferComposer.class, TransferTransactionComposer::new);
    }

    @Override
    public void init(Impactor api, PluginLogger logger) throws Exception {
        EconomyRegistrationProvider economy = new EconomyRegistrationProvider();
        api.events().post((Object)new ImpactorSuggestEconomyServiceEvent(economy));
        String service = economy.suggestion().metadata().name().orElse(economy.suggestion().metadata().id());
        logger.info("Registering economy service (Provider: " + service + ")");
        api.services().register(EconomyService.class, economy.suggestion().supplier().get());
    }
}

