/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.impactdev.impactor.api.configuration.Config;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.currency.CurrencyProvider;
import net.impactdev.impactor.api.storage.StorageType;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.core.economy.EconomyConfig;
import net.impactdev.impactor.core.economy.currency.ImpactorCurrencyProvider;
import net.impactdev.impactor.core.economy.storage.EconomyStorage;
import net.impactdev.impactor.core.economy.storage.StorageFactory;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;

public final class ImpactorEconomyService
implements EconomyService {
    private final CurrencyProvider provider;
    private final EconomyStorage storage;
    private final Config config = (Config)Config.builder().path(BaseImpactorPlugin.instance().configurationDirectory().resolve("economy.conf")).provider(EconomyConfig.class).provideIfMissing(() -> BaseImpactorPlugin.instance().resource(root -> root.resolve("configs").resolve("economy.conf"))).build();

    public ImpactorEconomyService() {
        List<Currency> currencies = this.config.get(EconomyConfig.CURRENCIES);
        if (currencies.isEmpty()) {
            throw new IllegalStateException("No currencies defined");
        }
        this.provider = new ImpactorCurrencyProvider(currencies);
        this.storage = StorageFactory.instance(BaseImpactorPlugin.instance(), this.config, StorageType.JSON);
        try {
            this.storage.init();
        }
        catch (Exception e) {
            ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
        }
    }

    @Override
    public String name() {
        return "Impactor Economy Service";
    }

    @Override
    public CurrencyProvider currencies() {
        return this.provider;
    }

    public EconomyStorage storage() {
        return this.storage;
    }

    public Config config() {
        return this.config;
    }

    @Override
    public CompletableFuture<Boolean> hasAccount(Currency currency, UUID uuid) {
        return this.storage.hasAccount(currency, uuid);
    }

    @Override
    public CompletableFuture<Account> account(Currency currency, UUID uuid) {
        return this.storage.account(currency, uuid, builder -> builder);
    }

    @Override
    public CompletableFuture<Account> account(Currency currency, UUID uuid, Account.AccountModifier modifier) {
        return this.storage.account(currency, uuid, modifier);
    }

    @Override
    public CompletableFuture<Multimap<Currency, Account>> accounts() {
        return this.storage.accounts();
    }

    @Override
    public CompletableFuture<Void> deleteAccount(Currency currency, UUID uuid) {
        return this.storage.delete(currency, uuid);
    }

    @Override
    public CompletableFuture<Void> save(Account account) {
        return this.storage.save(account);
    }
}

