/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.currency;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.util.TriState;
import org.jetbrains.annotations.NotNull;

public class ImpactorCurrency
implements Currency {
    private final Key key;
    private final Component name;
    private final Component plural;
    private final Component symbol;
    private final BigDecimal starting;
    private final int decimals;
    private final Currency.CurrencyFormatting formatting;
    private final boolean primary;
    private final TriState transferable;
    private final String formatPattern;

    private ImpactorCurrency(ImpactorCurrencyBuilder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.plural = builder.plural;
        this.symbol = builder.symbol;
        this.starting = builder.starting;
        this.decimals = builder.decimals;
        this.formatting = builder.formatting;
        this.primary = builder.primary;
        this.transferable = builder.transferable;
        StringBuilder sb = new StringBuilder();
        sb.append("#,##0");
        if (this.decimals > 0) {
            sb.append(".");
            sb.append(Strings.repeat((String)"0", (int)this.decimals));
        }
        this.formatPattern = sb.toString();
    }

    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public Component singular() {
        return this.name;
    }

    @Override
    public Component plural() {
        return this.plural;
    }

    @Override
    public Component symbol() {
        return this.symbol;
    }

    @Override
    public Currency.CurrencyFormatting formatting() {
        return this.formatting;
    }

    @Override
    public Component format(@NotNull BigDecimal amount, boolean condensed, @NotNull Locale locale) {
        DecimalFormat formatter = new DecimalFormat(this.formatPattern, new DecimalFormatSymbols(locale));
        MiniMessage mini = MiniMessage.miniMessage();
        TagResolver.Single symbol = Placeholder.component((String)"symbol", (ComponentLike)this.symbol);
        TagResolver.Single value = Placeholder.component((String)"amount", (ComponentLike)Component.text((String)formatter.format(amount.doubleValue())));
        TagResolver.Single expanded = Placeholder.component((String)"name", (ComponentLike)(amount.doubleValue() == 1.0 ? this.singular() : this.plural()));
        return mini.deserialize(condensed ? this.formatting.condensed() : this.formatting.expanded(), new TagResolver[]{symbol, value, expanded});
    }

    @Override
    public BigDecimal defaultAccountBalance() {
        return this.starting;
    }

    @Override
    public int decimals() {
        return this.decimals;
    }

    @Override
    public boolean primary() {
        return this.primary;
    }

    @Override
    public TriState transferable() {
        return this.transferable;
    }

    public static class ImpactorCurrencyBuilder
    implements Currency.CurrencyBuilder {
        private Key key;
        private Component name;
        private Component plural;
        private Component symbol;
        private Currency.CurrencyFormatting formatting;
        private BigDecimal starting;
        private int decimals;
        private boolean primary;
        private TriState transferable = TriState.NOT_SET;
        private String formatTemplate;

        @Override
        public Currency.CurrencyBuilder key(@NotNull Key key) {
            this.key = key;
            return this;
        }

        @Override
        public Currency.CurrencyBuilder name(@NotNull Component name) {
            this.name = name;
            return this;
        }

        @Override
        public Currency.CurrencyBuilder plural(@NotNull Component plural) {
            this.plural = plural;
            return this;
        }

        @Override
        public Currency.CurrencyBuilder symbol(@NotNull Component symbol) {
            this.symbol = symbol;
            return this;
        }

        @Override
        public Currency.CurrencyBuilder formatting(@NotNull Currency.CurrencyFormatting format) {
            this.formatting = format;
            return this;
        }

        @Override
        public Currency.CurrencyBuilder starting(@NotNull BigDecimal amount) {
            this.starting = amount;
            return this;
        }

        @Override
        public Currency.CurrencyBuilder decimals(int decimals) {
            this.decimals = decimals;
            return this;
        }

        @Override
        public Currency.CurrencyBuilder primary() {
            this.primary = true;
            return this;
        }

        @Override
        public Currency.CurrencyBuilder transferable(boolean state) {
            this.transferable = TriState.byBoolean((boolean)state);
            return this;
        }

        @Override
        public Currency build() {
            return new ImpactorCurrency(this);
        }
    }
}

