/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.currency;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.currency.CurrencyProvider;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Cache;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;

public class ImpactorCurrencyProvider
implements CurrencyProvider {
    private final Currency primary;
    private final Cache<Key, Currency> currencies = Caffeine.newBuilder().build();
    private final ReentrantLock lock = new ReentrantLock();

    public ImpactorCurrencyProvider(List<Currency> currencies) {
        this.primary = currencies.stream().filter(Currency::primary).findFirst().orElse(currencies.get(0));
        currencies.forEach(currency -> this.currencies.put(currency.key(), (Currency)currency));
    }

    @Override
    @NotNull
    public Currency primary() {
        return this.primary;
    }

    @Override
    public Optional<Currency> currency(Key key) {
        return Optional.ofNullable(this.currencies.getIfPresent(key));
    }

    @Override
    public Set<Currency> registered() {
        return new HashSet<Currency>(this.currencies.asMap().values());
    }

    @Override
    public CompletableFuture<Boolean> register(Currency currency) {
        return CompletableFuture.supplyAsync(() -> {
            this.lock.lock();
            try {
                if (this.currencies.getIfPresent(currency.key()) != null) {
                    Boolean bl = false;
                    return bl;
                }
                this.currencies.put(currency.key(), currency);
                Boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        });
    }
}

