/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.events;

import java.math.BigDecimal;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.events.EconomyTransactionEvent;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;

public abstract class ImpactorEconomyTransactionEvent
implements EconomyTransactionEvent {
    private final Currency currency;
    private final Account account;

    public ImpactorEconomyTransactionEvent(Currency currency, Account account) {
        this.currency = currency;
        this.account = account;
    }

    @Override
    public Currency currency() {
        return this.currency;
    }

    @Override
    public Account account() {
        return this.account;
    }

    public static final class Post
    extends ImpactorEconomyTransactionEvent
    implements EconomyTransactionEvent.Post {
        private final EconomyTransaction transaction;

        public Post(EconomyTransaction transaction) {
            super(transaction.currency(), transaction.account());
            this.transaction = transaction;
        }

        @Override
        public EconomyTransaction transaction() {
            return this.transaction;
        }
    }

    public static final class Pre
    extends ImpactorEconomyTransactionEvent
    implements EconomyTransactionEvent.Pre {
        private final BigDecimal amount;
        private final EconomyTransactionType type;
        private boolean cancelled = false;

        public Pre(Currency currency, Account account, BigDecimal amount, EconomyTransactionType type) {
            super(currency, account);
            this.amount = amount;
            this.type = type;
        }

        @Override
        public BigDecimal amount() {
            return this.amount;
        }

        @Override
        public EconomyTransactionType type() {
            return this.type;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }
}

