/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.events;

import java.math.BigDecimal;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.events.EconomyTransferTransactionEvent;
import net.impactdev.impactor.api.economy.transactions.EconomyTransferTransaction;

public class ImpactorEconomyTransferTransactionEvent
implements EconomyTransferTransactionEvent {
    private final Currency currency;
    private final Account from;
    private final Account to;

    public ImpactorEconomyTransferTransactionEvent(Currency currency, Account from, Account to) {
        this.currency = currency;
        this.from = from;
        this.to = to;
    }

    @Override
    public Currency currency() {
        return this.currency;
    }

    @Override
    public Account from() {
        return this.from;
    }

    @Override
    public Account to() {
        return this.to;
    }

    public static final class Post
    extends ImpactorEconomyTransferTransactionEvent
    implements EconomyTransferTransactionEvent.Post {
        private final EconomyTransferTransaction transaction;

        public Post(EconomyTransferTransaction transaction) {
            super(transaction.currency(), transaction.from(), transaction.to());
            this.transaction = transaction;
        }

        @Override
        public EconomyTransferTransaction transaction() {
            return this.transaction;
        }
    }

    public static final class Pre
    extends ImpactorEconomyTransferTransactionEvent
    implements EconomyTransferTransactionEvent.Pre {
        private final BigDecimal amount;
        private boolean cancelled;

        public Pre(Currency currency, Account from, Account to, BigDecimal amount) {
            super(currency, from, to);
            this.amount = amount;
        }

        @Override
        public BigDecimal amount() {
            return this.amount;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancelled(boolean cancelled) {
            this.cancelled = true;
        }
    }
}

