/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.placeholders;

import com.google.common.base.Suppliers;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.text.placeholders.PlaceholderArguments;
import net.impactdev.impactor.api.text.placeholders.PlaceholderParser;
import net.impactdev.impactor.api.utility.Context;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccountPlaceholderParser
implements PlaceholderParser {
    private static final Supplier<EconomyService> service = Suppliers.memoize(EconomyService::instance);
    private final AsyncLoadingCache<AccountRequest, Account> cache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).buildAsync(request -> service.get().account(request.currency, request.uuid).join());

    @Override
    @NotNull
    public Component parse(@Nullable PlatformSource viewer, @NotNull Context context) {
        PlaceholderArguments arguments = context.require(PlaceholderArguments.class);
        Currency currency = this.currency(arguments);
        Resolver resolver = this.resolver(arguments);
        return context.request(Account.class).map(resolver::resolve).orElseGet(() -> {
            Account relative;
            if (viewer != null && (relative = (Account)this.cache.get(new AccountRequest(viewer.uuid(), currency)).getNow(null)) != null) {
                return resolver.resolve(relative);
            }
            return Component.text((String)"Fetching balance...");
        });
    }

    private Currency currency(PlaceholderArguments arguments) {
        arguments.reset();
        while (arguments.hasNext()) {
            Pattern pattern = Pattern.compile("(?<namespace>[a-z0-9_\\-.]+)/(?<value>[a-z0-9_\\-./]+)");
            Matcher matcher = pattern.matcher(arguments.pop());
            if (!matcher.matches()) continue;
            String namespace = matcher.group("namespace");
            String value = matcher.group("value");
            return service.get().currencies().currency(Key.key((String)namespace, (String)value)).orElse(service.get().currencies().primary());
        }
        return service.get().currencies().primary();
    }

    private Resolver resolver(PlaceholderArguments arguments) {
        arguments.reset();
        while (arguments.hasNext()) {
            String argument = arguments.pop();
            if (argument.equals("balance")) {
                return Resolvers.BALANCE.resolver;
            }
            if (!argument.equals("name")) continue;
            return Resolvers.NAME.resolver;
        }
        return Resolvers.BALANCE.resolver;
    }

    @FunctionalInterface
    private static interface Resolver {
        public Component resolve(Account var1);
    }

    private static enum Resolvers {
        BALANCE(account -> account.currency().format(account.balance())),
        NAME(account -> {
            PlatformSource source2 = PlatformSource.factory().fromID(account.owner());
            return source2.name();
        });

        private final Resolver resolver;

        private Resolvers(Resolver resolver) {
            this.resolver = resolver;
        }
    }

    private record AccountRequest(UUID uuid, Currency currency) {
    }
}

