/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.registration;

import java.util.Optional;
import java.util.function.Supplier;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.platform.plugins.PluginMetadata;
import net.impactdev.impactor.core.economy.ImpactorEconomyService;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;

public final class EconomyRegistrationProvider {
    private EconomySuggestion suggestion;

    public EconomyRegistrationProvider() {
        this.suggest(BaseImpactorPlugin.instance().metadata(), 0, ImpactorEconomyService::new);
    }

    public EconomySuggestion suggestion() {
        return Optional.ofNullable(this.suggestion).orElseThrow(() -> new IllegalStateException("No suggestions available"));
    }

    public void suggest(PluginMetadata metadata, int priority, Supplier<EconomyService> supplier) {
        if (this.suggestion == null || this.suggestion.priority() < priority) {
            this.suggestion = this.createSuggestion(metadata, priority, supplier);
        }
    }

    private EconomySuggestion createSuggestion(PluginMetadata metadata, int priority, Supplier<EconomyService> supplier) {
        return new EconomySuggestion(metadata, priority, supplier);
    }

    public static final class EconomySuggestion {
        private final PluginMetadata metadata;
        private final int priority;
        private final Supplier<EconomyService> supplier;

        private EconomySuggestion(PluginMetadata metadata, int priority, Supplier<EconomyService> supplier) {
            this.metadata = metadata;
            this.priority = priority;
            this.supplier = supplier;
        }

        public PluginMetadata metadata() {
            return this.metadata;
        }

        public int priority() {
            return this.priority;
        }

        public Supplier<EconomyService> supplier() {
            return this.supplier;
        }
    }
}

