/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.storage;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.scheduler.v2.Scheduler;
import net.impactdev.impactor.api.scheduler.v2.Schedulers;
import net.impactdev.impactor.api.storage.Storage;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.core.economy.storage.EconomyStorageImplementation;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.utility.future.ThrowingRunnable;
import net.impactdev.impactor.core.utility.future.ThrowingSupplier;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Cache;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;

public final class EconomyStorage
implements Storage {
    private final EconomyStorageImplementation implementation;
    private final Cache<AccountKey, Account> accounts;

    public EconomyStorage(EconomyStorageImplementation implementation) {
        this.implementation = implementation;
        this.accounts = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    }

    @Override
    public void init() throws Exception {
        this.implementation.init();
    }

    @Override
    public void shutdown() throws Exception {
        this.implementation.shutdown();
    }

    @Override
    public CompletableFuture<Void> meta(PrettyPrinter printer) {
        return EconomyStorage.run(() -> this.implementation.meta(printer));
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Boolean> hasAccount(Currency currency, UUID uuid) {
        if (this.accounts.getIfPresent(AccountKey.of(currency, uuid)) != null) {
            return CompletableFuture.completedFuture(true);
        }
        return EconomyStorage.supply(() -> this.implementation.hasAccount(currency, uuid));
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Account> account(Currency currency, UUID uuid, Account.AccountModifier modifier) {
        Account account = this.accounts.getIfPresent(AccountKey.of(currency, uuid));
        if (account != null) {
            return CompletableFuture.completedFuture(account);
        }
        return EconomyStorage.supply(() -> {
            Account result = this.implementation.account(currency, uuid, modifier);
            this.accounts.put(AccountKey.of(currency, uuid), result);
            return result;
        });
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Void> save(Account account) {
        return EconomyStorage.run(() -> this.implementation.save(account));
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Multimap<Currency, Account>> accounts() {
        ArrayListMultimap results = ArrayListMultimap.create();
        this.accounts.asMap().forEach((arg_0, arg_1) -> EconomyStorage.lambda$accounts$4((Multimap)results, arg_0, arg_1));
        return EconomyStorage.run(() -> this.lambda$accounts$5((Multimap)results)).thenApply(arg_0 -> EconomyStorage.lambda$accounts$6((Multimap)results, arg_0));
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Void> delete(Currency currency, UUID uuid) {
        return EconomyStorage.run(() -> {
            this.implementation.delete(currency, uuid);
            this.accounts.invalidate(AccountKey.of(currency, uuid));
        });
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Void> logTransaction(EconomyTransaction transaction) {
        return CompletableFuture.completedFuture(null);
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Void> sync(Account account, Instant since) {
        return CompletableFuture.completedFuture(null);
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Boolean> purge() {
        return EconomyStorage.supply(this.implementation::purge);
    }

    private static CompletableFuture<Void> run(ThrowingRunnable runnable2) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable2.run();
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        }, Schedulers.require(Scheduler.ASYNCHRONOUS).executor());
    }

    private static <T> CompletableFuture<T> supply(ThrowingSupplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.supply();
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        }, Schedulers.require(Scheduler.ASYNCHRONOUS).executor());
    }

    private static /* synthetic */ Multimap lambda$accounts$6(Multimap results, Void ignore) {
        return results;
    }

    private /* synthetic */ void lambda$accounts$5(Multimap results) throws Exception {
        this.implementation.accounts((Multimap<Currency, Account>)results);
    }

    private static /* synthetic */ void lambda$accounts$4(Multimap results, AccountKey key, Account account) {
        results.put((Object)key.currency, (Object)account);
    }

    private record AccountKey(Currency currency, UUID owner) {
        public static AccountKey of(Currency currency, UUID owner) {
            return new AccountKey(currency, owner);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccountKey that = (AccountKey)o;
            return this.currency.equals(that.currency) && this.owner.equals(that.owner);
        }
    }
}

