/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.storage.implementations;

import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.currency.CurrencyProvider;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.storage.connection.sql.SQLConnection;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.core.economy.accounts.ImpactorAccount;
import net.impactdev.impactor.core.economy.storage.EconomyStorageImplementation;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.kyori.adventure.key.Key;

public final class SQLProvider
implements EconomyStorageImplementation {
    public static final String HAS_ACCOUNT = "SELECT 1 FROM '{prefix}accounts' WHERE uuid = ? AND currency = ?";
    public static final String ACCOUNT = "SELECT * FROM '{prefix}accounts' WHERE uuid = ? AND currency = ?";
    public static final String UPDATE_OR_INSERT_ACCOUNT = "INSERT INTO '{prefix}accounts' (uuid, currency, virtual, balance) VALUES(?, ?, ?, ?) ON DUPLICATE KEY UPDATE balance = VALUES(balance)";
    public static final String ALL_ACCOUNTS = "SELECT * FROM '{prefix}accounts'";
    public static final String DELETE_ACCOUNT = "DELETE FROM '{prefix}accounts' WHERE uuid = ? AND currency = ?";
    public static final String TRUNCATE_ACCOUNTS = "TRUNCATE TABLE '{prefix}accounts'";
    private final BaseImpactorPlugin plugin = BaseImpactorPlugin.instance();
    private final SQLConnection factory;
    private final Function<String, String> processor;

    public SQLProvider(SQLConnection connection, String prefix) {
        this.factory = connection;
        this.processor = connection.statementProcessor().compose(s -> s.replace("{prefix}", prefix));
    }

    @Override
    public String name() {
        return this.factory.name();
    }

    @Override
    public void init() throws Exception {
        this.factory.init();
        try (InputStream schema = this.plugin.resource(root -> root.resolve("schema").resolve(this.factory.name().toLowerCase() + ".sql"));
             BufferedReader reader = new BufferedReader(new InputStreamReader(schema, StandardCharsets.UTF_8));
             Connection connection = this.factory.connection();
             Statement s = connection.createStatement();){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("--") || line.startsWith("#")) continue;
                sb.append(line);
                if (!line.endsWith(";")) continue;
                sb.deleteCharAt(sb.length() - 1);
                String result = this.processor.apply(sb.toString().trim());
                if (!result.isEmpty()) {
                    if (result.startsWith("set mode")) {
                        s.addBatch(result);
                    } else if (SchemaReaders.any(this, result)) {
                        SchemaReaders.first(this, result, s);
                    }
                }
                sb = new StringBuilder();
            }
            s.executeBatch();
        }
    }

    @Override
    public void shutdown() throws Exception {
        this.factory.shutdown();
    }

    @Override
    public void meta(PrettyPrinter printer) throws Exception {
        this.factory.meta(printer);
    }

    @Override
    public boolean hasAccount(Currency currency, UUID uuid) throws Exception {
        return this.query(HAS_ACCOUNT, (connection, ps) -> {
            ps.setBytes(1, this.uuidToBytes(uuid));
            ps.setString(2, currency.key().asString());
            return ps.executeQuery().next();
        });
    }

    @Override
    public Account account(Currency currency, UUID uuid, Account.AccountModifier modifier) throws Exception {
        return this.query(ACCOUNT, (connection, ps) -> {
            ps.setBytes(1, this.uuidToBytes(uuid));
            ps.setString(2, currency.key().asString());
            return this.results(ps, results -> {
                Account account;
                if (results.next()) {
                    Account.AccountBuilder builder = Account.builder().owner(this.bytesToUUID(results.getBytes("uuid"))).currency(currency).balance(results.getBigDecimal("balance"));
                    if (results.getBoolean("virtual")) {
                        builder.virtual();
                    }
                    account = (Account)builder.build();
                } else {
                    ImpactorAccount.ImpactorAccountBuilder builder = new ImpactorAccount.ImpactorAccountBuilder();
                    builder.currency(currency).owner(uuid);
                    account = (Account)modifier.modify(builder).build();
                    this.save(account);
                }
                return account;
            });
        });
    }

    @Override
    public void save(Account account) throws Exception {
        this.query(UPDATE_OR_INSERT_ACCOUNT, (connection, ps) -> {
            ps.setBytes(1, this.uuidToBytes(account.owner()));
            ps.setString(2, account.currency().key().asString());
            ps.setBoolean(3, account.virtual());
            ps.setBigDecimal(4, account.balance());
            ps.executeUpdate();
            return null;
        });
    }

    @Override
    public void accounts(Multimap<Currency, Account> cache) throws Exception {
        this.query(ALL_ACCOUNTS, (connection, ps) -> this.results(ps, results -> {
            EconomyService service = EconomyService.instance();
            CurrencyProvider provider = service.currencies();
            while (results.next()) {
                Key key = Key.key((String)results.getString("currency"));
                Optional<Currency> currency = provider.currency(key);
                if (!currency.isPresent()) continue;
                Account.AccountBuilder account = Account.builder().owner(this.bytesToUUID(results.getBytes("uuid"))).currency(currency.get()).balance(results.getBigDecimal("balance"));
                if (results.getBoolean("virtual")) {
                    account.virtual();
                }
                cache.put((Object)currency.get(), (Object)((Account)account.build()));
            }
            return null;
        }));
    }

    @Override
    public void delete(Currency currency, UUID uuid) throws Exception {
        this.query(DELETE_ACCOUNT, (connection, ps) -> {
            ps.setBytes(1, this.uuidToBytes(uuid));
            ps.setString(2, currency.key().asString());
            return null;
        });
    }

    @Override
    public void logTransaction(EconomyTransaction transaction) throws Exception {
    }

    @Override
    public void sync(Account account, Instant since) throws Exception {
    }

    @Override
    public boolean purge() throws Exception {
        return this.query(TRUNCATE_ACCOUNTS, (connection, ps) -> {
            ps.executeUpdate();
            return null;
        });
    }

    private boolean tableExists(String table) throws SQLException {
        try (Connection connection = this.factory.connection();){
            boolean bl;
            block16: {
                boolean bl2;
                ResultSet rs = connection.getMetaData().getTables(null, null, "%", null);
                try {
                    while (rs.next()) {
                        if (!rs.getString(3).equalsIgnoreCase(table)) continue;
                        bl2 = true;
                        if (rs == null) break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                {
                    block15: {
                        rs.close();
                    }
                    return bl2;
                }
                bl = false;
                if (rs == null) break block16;
                rs.close();
            }
            return bl;
        }
    }

    private byte[] uuidToBytes(UUID uuid) {
        byte[] bytes = new byte[16];
        ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return bytes;
    }

    private UUID bytesToUUID(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return new UUID(buffer.getLong(), buffer.getLong());
    }

    private <T> T query(String key, Query<T> action) throws Exception {
        try (Connection connection = this.factory.connection();){
            T t;
            block12: {
                PreparedStatement ps = connection.prepareStatement(this.processor.apply(key));
                try {
                    t = action.prepare(connection, ps);
                    if (ps == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return t;
        }
    }

    private <T> T results(PreparedStatement ps, Results<T> action) throws Exception {
        try (ResultSet rs = ps.executeQuery();){
            T t = action.results(rs);
            return t;
        }
    }

    private static enum SchemaReaders {
        CREATE_TABLE((impl, in) -> in.startsWith("CREATE TABLE"), (impl, in) -> !impl.tableExists(SchemaReaders.getTable(in))),
        ALTER_TABLE((impl, in) -> in.startsWith("ALTER TABLE"), (impl, in) -> impl.tableExists(SchemaReaders.getTable(in))),
        ANY((impl, input) -> true, (impl, input) -> true);

        private final SchemaPredicate initial;
        private final SchemaPredicate last;

        private SchemaReaders(SchemaPredicate initial, SchemaPredicate last) {
            this.initial = initial;
            this.last = last;
        }

        public static boolean any(SQLProvider impl, String in) {
            return Arrays.stream(SchemaReaders.values()).map(sr -> {
                try {
                    return sr.initial.test(impl, in);
                }
                catch (Exception e) {
                    ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                    return false;
                }
            }).filter(x -> x).findAny().orElse(false);
        }

        public static void first(SQLProvider impl, String in, Statement statement) throws Exception {
            for (SchemaReaders reader : SchemaReaders.values()) {
                if (reader != ANY) {
                    if (!reader.initial.test(impl, in) || !reader.last.test(impl, in)) continue;
                    statement.addBatch(in);
                    return;
                }
                for (SchemaReaders r : Arrays.stream(SchemaReaders.values()).filter(sr -> sr != ANY).toList()) {
                    if (!r.initial.test(impl, in)) continue;
                    return;
                }
                statement.addBatch(in);
            }
        }

        private static String getTable(String in) {
            int start = in.indexOf(96);
            return in.substring(start + 1, in.indexOf(96, start + 1));
        }
    }

    @FunctionalInterface
    private static interface Query<T> {
        public T prepare(Connection var1, PreparedStatement var2) throws Exception;
    }

    @FunctionalInterface
    private static interface Results<T> {
        public T results(ResultSet var1) throws Exception;
    }

    private static interface SchemaPredicate {
        public boolean test(SQLProvider var1, String var2) throws Exception;
    }
}

