/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.transactions;

import java.math.BigDecimal;
import java.util.function.Supplier;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransferTransaction;
import net.impactdev.impactor.api.economy.transactions.details.EconomyResultType;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public final class ImpactorEconomyTransferTransaction
implements EconomyTransferTransaction {
    private final Currency currency;
    private final Account from;
    private final Account to;
    private final BigDecimal amount;
    private final EconomyResultType result;
    private final Supplier<Component> message;

    public ImpactorEconomyTransferTransaction(TransactionBuilder builder) {
        this.currency = builder.currency;
        this.from = builder.from;
        this.to = builder.to;
        this.amount = builder.amount;
        this.result = builder.result;
        this.message = builder.message;
    }

    @Override
    public Currency currency() {
        return this.currency;
    }

    @Override
    public Account from() {
        return this.from;
    }

    @Override
    public Account to() {
        return this.to;
    }

    @Override
    public BigDecimal amount() {
        return this.amount;
    }

    @Override
    public EconomyResultType result() {
        return this.result;
    }

    @Override
    @Nullable
    public Supplier<Component> message() {
        return this.message;
    }

    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    public static final class TransactionBuilder
    implements Builder<EconomyTransferTransaction> {
        private Currency currency;
        private Account from;
        private Account to;
        private BigDecimal amount;
        private EconomyResultType result;
        private Supplier<Component> message;

        public TransactionBuilder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public TransactionBuilder from(Account account) {
            this.from = account;
            return this;
        }

        public TransactionBuilder to(Account account) {
            this.to = account;
            return this;
        }

        public TransactionBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public TransactionBuilder result(EconomyResultType result) {
            this.result = result;
            return this;
        }

        public TransactionBuilder message(Supplier<Component> message) {
            this.message = message;
            return this;
        }

        @Override
        public EconomyTransferTransaction build() {
            return new ImpactorEconomyTransferTransaction(this);
        }
    }
}

