/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.transactions.composers;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.transactions.EconomyTransferTransaction;
import net.impactdev.impactor.api.economy.transactions.composer.TransferComposer;
import net.impactdev.impactor.api.economy.transactions.details.EconomyResultType;
import net.impactdev.impactor.core.economy.accounts.ImpactorAccount;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public final class TransferTransactionComposer
implements TransferComposer {
    private Account from;
    private Account to;
    private BigDecimal amount;
    private final Map<EconomyResultType, Supplier<Component>> messages = new HashMap<EconomyResultType, Supplier<Component>>();

    public Account target() {
        return this.to;
    }

    public BigDecimal amount() {
        return this.amount;
    }

    public Map<EconomyResultType, Supplier<Component>> messages() {
        return this.messages;
    }

    @Override
    public TransferComposer from(@NotNull Account account) {
        this.from = account;
        return this;
    }

    @Override
    public TransferComposer to(@NotNull Account account) {
        this.to = account;
        return this;
    }

    @Override
    public TransferComposer amount(@NotNull BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public TransferComposer message(@NotNull EconomyResultType type, @NotNull @NotNull Supplier<@NotNull Component> message) {
        this.messages.put(type, message);
        return this;
    }

    @Override
    @NotNull
    public EconomyTransferTransaction build() {
        Preconditions.checkNotNull((Object)this.from, (Object)"from");
        Preconditions.checkNotNull((Object)this.to, (Object)"to");
        Preconditions.checkNotNull((Object)this.amount, (Object)"amount");
        ImpactorAccount account = (ImpactorAccount)this.from;
        return account.transfer(this);
    }
}

