/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.mail;

import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import net.impactdev.impactor.api.mail.MailMessage;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ImpactorMailMessage(@NotNull UUID uuid, @Nullable UUID sender, @NotNull Component content, @NotNull Instant timestamp) implements MailMessage
{
    @Override
    public Optional<UUID> source() {
        return Optional.ofNullable(this.sender);
    }

    public static class MaillMessageFactory
    implements MailMessage.Factory {
        @Override
        public MailMessage create(Component message) {
            return new ImpactorMailMessage(UUID.randomUUID(), null, message, Instant.now());
        }

        @Override
        public MailMessage create(UUID source2, Component message) {
            return new ImpactorMailMessage(UUID.randomUUID(), source2, message, Instant.now());
        }
    }
}

