/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.mail.registration;

import java.util.Optional;
import java.util.function.Supplier;
import net.impactdev.impactor.api.mail.MailService;
import net.impactdev.impactor.api.platform.plugins.PluginMetadata;
import net.impactdev.impactor.core.mail.ImpactorMailService;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;

public final class MailServiceRegistrationProvider {
    private MailServiceSuggestion suggestion;

    public MailServiceRegistrationProvider() {
        this.suggest(BaseImpactorPlugin.instance().metadata(), 0, ImpactorMailService::new);
    }

    public MailServiceSuggestion suggestion() {
        return Optional.ofNullable(this.suggestion).orElseThrow(() -> new IllegalStateException("No suggestions available"));
    }

    public void suggest(PluginMetadata metadata, int priority, Supplier<MailService> supplier) {
        if (this.suggestion == null || this.suggestion.priority() < priority) {
            this.suggestion = this.createSuggestion(metadata, priority, supplier);
        }
    }

    private MailServiceSuggestion createSuggestion(PluginMetadata metadata, int priority, Supplier<MailService> supplier) {
        return new MailServiceSuggestion(metadata, priority, supplier);
    }

    public static final class MailServiceSuggestion {
        private final PluginMetadata metadata;
        private final int priority;
        private final Supplier<MailService> supplier;

        private MailServiceSuggestion(PluginMetadata metadata, int priority, Supplier<MailService> supplier) {
            this.metadata = metadata;
            this.priority = priority;
            this.supplier = supplier;
        }

        public PluginMetadata metadata() {
            return this.metadata;
        }

        public int priority() {
            return this.priority;
        }

        public Supplier<MailService> supplier() {
            return this.supplier;
        }
    }
}

